package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SyntaxToken(
    tokenId: Option[Integer] = None,
    text: Option[String] = None,
    beginOffset: Option[Integer] = None,
    endOffset: Option[Integer] = None,
    partOfSpeech: Option[zio.aws.comprehend.model.PartOfSpeechTag] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.SyntaxToken = {
    import SyntaxToken.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.SyntaxToken
      .builder()
      .optionallyWith(
        tokenId.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.tokenId)
      .optionallyWith(text.map(value => value: java.lang.String))(_.text)
      .optionallyWith(
        beginOffset.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.beginOffset)
      .optionallyWith(
        endOffset.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.endOffset)
      .optionallyWith(partOfSpeech.map(value => value.buildAwsValue()))(
        _.partOfSpeech
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.SyntaxToken.ReadOnly =
    zio.aws.comprehend.model.SyntaxToken.wrap(buildAwsValue())
}
object SyntaxToken {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.SyntaxToken
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.SyntaxToken =
      zio.aws.comprehend.model.SyntaxToken(
        tokenId.map(value => value),
        text.map(value => value),
        beginOffset.map(value => value),
        endOffset.map(value => value),
        partOfSpeech.map(value => value.asEditable)
      )
    def tokenId: Option[Integer]
    def text: Option[String]
    def beginOffset: Option[Integer]
    def endOffset: Option[Integer]
    def partOfSpeech: Option[zio.aws.comprehend.model.PartOfSpeechTag.ReadOnly]
    def getTokenId: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("tokenId", tokenId)
    def getText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("text", text)
    def getBeginOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("beginOffset", beginOffset)
    def getEndOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("endOffset", endOffset)
    def getPartOfSpeech: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.PartOfSpeechTag.ReadOnly
    ] = AwsError.unwrapOptionField("partOfSpeech", partOfSpeech)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.SyntaxToken
  ) extends zio.aws.comprehend.model.SyntaxToken.ReadOnly {
    override val tokenId: Option[Integer] = scala
      .Option(impl.tokenId())
      .map(value => zio.aws.comprehend.model.primitives.Integer(value))
    override val text: Option[String] =
      scala.Option(impl.text()).map(value => value: String)
    override val beginOffset: Option[Integer] = scala
      .Option(impl.beginOffset())
      .map(value => zio.aws.comprehend.model.primitives.Integer(value))
    override val endOffset: Option[Integer] = scala
      .Option(impl.endOffset())
      .map(value => zio.aws.comprehend.model.primitives.Integer(value))
    override val partOfSpeech
        : Option[zio.aws.comprehend.model.PartOfSpeechTag.ReadOnly] = scala
      .Option(impl.partOfSpeech())
      .map(value => zio.aws.comprehend.model.PartOfSpeechTag.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.SyntaxToken
  ): zio.aws.comprehend.model.SyntaxToken.ReadOnly = new Wrapper(impl)
}
