package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchDetectSentimentItemResult(
    index: Option[Integer] = None,
    sentiment: Option[zio.aws.comprehend.model.SentimentType] = None,
    sentimentScore: Option[zio.aws.comprehend.model.SentimentScore] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentItemResult = {
    import BatchDetectSentimentItemResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentItemResult
      .builder()
      .optionallyWith(
        index.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.index)
      .optionallyWith(sentiment.map(value => value.unwrap))(_.sentiment)
      .optionallyWith(sentimentScore.map(value => value.buildAwsValue()))(
        _.sentimentScore
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.BatchDetectSentimentItemResult.ReadOnly =
    zio.aws.comprehend.model.BatchDetectSentimentItemResult
      .wrap(buildAwsValue())
}
object BatchDetectSentimentItemResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentItemResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.BatchDetectSentimentItemResult =
      zio.aws.comprehend.model.BatchDetectSentimentItemResult(
        index.map(value => value),
        sentiment.map(value => value),
        sentimentScore.map(value => value.asEditable)
      )
    def index: Option[Integer]
    def sentiment: Option[zio.aws.comprehend.model.SentimentType]
    def sentimentScore: Option[zio.aws.comprehend.model.SentimentScore.ReadOnly]
    def getIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("index", index)
    def getSentiment
        : ZIO[Any, AwsError, zio.aws.comprehend.model.SentimentType] =
      AwsError.unwrapOptionField("sentiment", sentiment)
    def getSentimentScore
        : ZIO[Any, AwsError, zio.aws.comprehend.model.SentimentScore.ReadOnly] =
      AwsError.unwrapOptionField("sentimentScore", sentimentScore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentItemResult
  ) extends zio.aws.comprehend.model.BatchDetectSentimentItemResult.ReadOnly {
    override val index: Option[Integer] = scala
      .Option(impl.index())
      .map(value => zio.aws.comprehend.model.primitives.Integer(value))
    override val sentiment: Option[zio.aws.comprehend.model.SentimentType] =
      scala
        .Option(impl.sentiment())
        .map(value => zio.aws.comprehend.model.SentimentType.wrap(value))
    override val sentimentScore
        : Option[zio.aws.comprehend.model.SentimentScore.ReadOnly] = scala
      .Option(impl.sentimentScore())
      .map(value => zio.aws.comprehend.model.SentimentScore.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentItemResult
  ): zio.aws.comprehend.model.BatchDetectSentimentItemResult.ReadOnly =
    new Wrapper(impl)
}
