package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchDetectSyntaxResponse(
    resultList: Iterable[zio.aws.comprehend.model.BatchDetectSyntaxItemResult],
    errorList: Iterable[zio.aws.comprehend.model.BatchItemError]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxResponse = {
    import BatchDetectSyntaxResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxResponse
      .builder()
      .resultList(resultList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .errorList(errorList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.BatchDetectSyntaxResponse.ReadOnly =
    zio.aws.comprehend.model.BatchDetectSyntaxResponse.wrap(buildAwsValue())
}
object BatchDetectSyntaxResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.BatchDetectSyntaxResponse =
      zio.aws.comprehend.model.BatchDetectSyntaxResponse(
        resultList.map { item =>
          item.asEditable
        },
        errorList.map { item =>
          item.asEditable
        }
      )
    def resultList
        : List[zio.aws.comprehend.model.BatchDetectSyntaxItemResult.ReadOnly]
    def errorList: List[zio.aws.comprehend.model.BatchItemError.ReadOnly]
    def getResultList: ZIO[Any, Nothing, List[
      zio.aws.comprehend.model.BatchDetectSyntaxItemResult.ReadOnly
    ]] = ZIO.succeed(resultList)
    def getErrorList: ZIO[Any, Nothing, List[
      zio.aws.comprehend.model.BatchItemError.ReadOnly
    ]] = ZIO.succeed(errorList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxResponse
  ) extends zio.aws.comprehend.model.BatchDetectSyntaxResponse.ReadOnly {
    override val resultList
        : List[zio.aws.comprehend.model.BatchDetectSyntaxItemResult.ReadOnly] =
      impl
        .resultList()
        .asScala
        .map { item =>
          zio.aws.comprehend.model.BatchDetectSyntaxItemResult.wrap(item)
        }
        .toList
    override val errorList
        : List[zio.aws.comprehend.model.BatchItemError.ReadOnly] = impl
      .errorList()
      .asScala
      .map { item =>
        zio.aws.comprehend.model.BatchItemError.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxResponse
  ): zio.aws.comprehend.model.BatchDetectSyntaxResponse.ReadOnly = new Wrapper(
    impl
  )
}
