package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.S3Uri
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EntityRecognizerDocuments(
    s3Uri: S3Uri,
    testS3Uri: Option[S3Uri] = None,
    inputFormat: Option[zio.aws.comprehend.model.InputFormat] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.EntityRecognizerDocuments = {
    import EntityRecognizerDocuments.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerDocuments
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .optionallyWith(
        testS3Uri.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.testS3Uri)
      .optionallyWith(inputFormat.map(value => value.unwrap))(_.inputFormat)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.EntityRecognizerDocuments.ReadOnly =
    zio.aws.comprehend.model.EntityRecognizerDocuments.wrap(buildAwsValue())
}
object EntityRecognizerDocuments {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerDocuments
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.EntityRecognizerDocuments =
      zio.aws.comprehend.model.EntityRecognizerDocuments(
        s3Uri,
        testS3Uri.map(value => value),
        inputFormat.map(value => value)
      )
    def s3Uri: S3Uri
    def testS3Uri: Option[S3Uri]
    def inputFormat: Option[zio.aws.comprehend.model.InputFormat]
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
    def getTestS3Uri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("testS3Uri", testS3Uri)
    def getInputFormat
        : ZIO[Any, AwsError, zio.aws.comprehend.model.InputFormat] =
      AwsError.unwrapOptionField("inputFormat", inputFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerDocuments
  ) extends zio.aws.comprehend.model.EntityRecognizerDocuments.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.comprehend.model.primitives.S3Uri(impl.s3Uri())
    override val testS3Uri: Option[S3Uri] = scala
      .Option(impl.testS3Uri())
      .map(value => zio.aws.comprehend.model.primitives.S3Uri(value))
    override val inputFormat: Option[zio.aws.comprehend.model.InputFormat] =
      scala
        .Option(impl.inputFormat())
        .map(value => zio.aws.comprehend.model.InputFormat.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerDocuments
  ): zio.aws.comprehend.model.EntityRecognizerDocuments.ReadOnly = new Wrapper(
    impl
  )
}
