package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DocumentClass(
    name: Option[String] = None,
    score: Option[Float] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DocumentClass = {
    import DocumentClass.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DocumentClass
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(score.map(value => value: java.lang.Float))(_.score)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DocumentClass.ReadOnly =
    zio.aws.comprehend.model.DocumentClass.wrap(buildAwsValue())
}
object DocumentClass {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DocumentClass
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DocumentClass =
      zio.aws.comprehend.model
        .DocumentClass(name.map(value => value), score.map(value => value))
    def name: Option[String]
    def score: Option[Float]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getScore: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("score", score)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClass
  ) extends zio.aws.comprehend.model.DocumentClass.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val score: Option[Float] =
      scala.Option(impl.score()).map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClass
  ): zio.aws.comprehend.model.DocumentClass.ReadOnly = new Wrapper(impl)
}
