package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClassifyDocumentResponse(
    classes: Option[Iterable[zio.aws.comprehend.model.DocumentClass]] = None,
    labels: Option[Iterable[zio.aws.comprehend.model.DocumentLabel]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ClassifyDocumentResponse = {
    import ClassifyDocumentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ClassifyDocumentResponse
      .builder()
      .optionallyWith(
        classes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.classes)
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.labels)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.ClassifyDocumentResponse.ReadOnly =
    zio.aws.comprehend.model.ClassifyDocumentResponse.wrap(buildAwsValue())
}
object ClassifyDocumentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ClassifyDocumentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ClassifyDocumentResponse =
      zio.aws.comprehend.model.ClassifyDocumentResponse(
        classes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        labels.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def classes: Option[List[zio.aws.comprehend.model.DocumentClass.ReadOnly]]
    def labels: Option[List[zio.aws.comprehend.model.DocumentLabel.ReadOnly]]
    def getClasses: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.DocumentClass.ReadOnly
    ]] = AwsError.unwrapOptionField("classes", classes)
    def getLabels: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.DocumentLabel.ReadOnly
    ]] = AwsError.unwrapOptionField("labels", labels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ClassifyDocumentResponse
  ) extends zio.aws.comprehend.model.ClassifyDocumentResponse.ReadOnly {
    override val classes
        : Option[List[zio.aws.comprehend.model.DocumentClass.ReadOnly]] = scala
      .Option(impl.classes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.DocumentClass.wrap(item)
        }.toList
      )
    override val labels
        : Option[List[zio.aws.comprehend.model.DocumentLabel.ReadOnly]] = scala
      .Option(impl.labels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.DocumentLabel.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ClassifyDocumentResponse
  ): zio.aws.comprehend.model.ClassifyDocumentResponse.ReadOnly = new Wrapper(
    impl
  )
}
