package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  IamRoleArn,
  AnyLengthString,
  Timestamp,
  EventTypeString,
  JobName,
  JobId,
  ComprehendArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class EventsDetectionJobProperties(
    jobId: Option[JobId] = None,
    jobArn: Option[ComprehendArn] = None,
    jobName: Option[JobName] = None,
    jobStatus: Option[zio.aws.comprehend.model.JobStatus] = None,
    message: Option[AnyLengthString] = None,
    submitTime: Option[Timestamp] = None,
    endTime: Option[Timestamp] = None,
    inputDataConfig: Option[zio.aws.comprehend.model.InputDataConfig] = None,
    outputDataConfig: Option[zio.aws.comprehend.model.OutputDataConfig] = None,
    languageCode: Option[zio.aws.comprehend.model.LanguageCode] = None,
    dataAccessRoleArn: Option[IamRoleArn] = None,
    targetEventTypes: Option[Iterable[EventTypeString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.EventsDetectionJobProperties = {
    import EventsDetectionJobProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.EventsDetectionJobProperties
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        jobArn.map(value => ComprehendArn.unwrap(value): java.lang.String)
      )(_.jobArn)
      .optionallyWith(
        jobName.map(value => JobName.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        message.map(value => AnyLengthString.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        submitTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.submitTime)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(inputDataConfig.map(value => value.buildAwsValue()))(
        _.inputDataConfig
      )
      .optionallyWith(outputDataConfig.map(value => value.buildAwsValue()))(
        _.outputDataConfig
      )
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        dataAccessRoleArn.map(value =>
          IamRoleArn.unwrap(value): java.lang.String
        )
      )(_.dataAccessRoleArn)
      .optionallyWith(
        targetEventTypes.map(value =>
          value.map { item =>
            EventTypeString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targetEventTypes)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.EventsDetectionJobProperties.ReadOnly =
    zio.aws.comprehend.model.EventsDetectionJobProperties.wrap(buildAwsValue())
}
object EventsDetectionJobProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.EventsDetectionJobProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.EventsDetectionJobProperties =
      zio.aws.comprehend.model.EventsDetectionJobProperties(
        jobId.map(value => value),
        jobArn.map(value => value),
        jobName.map(value => value),
        jobStatus.map(value => value),
        message.map(value => value),
        submitTime.map(value => value),
        endTime.map(value => value),
        inputDataConfig.map(value => value.asEditable),
        outputDataConfig.map(value => value.asEditable),
        languageCode.map(value => value),
        dataAccessRoleArn.map(value => value),
        targetEventTypes.map(value => value)
      )
    def jobId: Option[JobId]
    def jobArn: Option[ComprehendArn]
    def jobName: Option[JobName]
    def jobStatus: Option[zio.aws.comprehend.model.JobStatus]
    def message: Option[AnyLengthString]
    def submitTime: Option[Timestamp]
    def endTime: Option[Timestamp]
    def inputDataConfig
        : Option[zio.aws.comprehend.model.InputDataConfig.ReadOnly]
    def outputDataConfig
        : Option[zio.aws.comprehend.model.OutputDataConfig.ReadOnly]
    def languageCode: Option[zio.aws.comprehend.model.LanguageCode]
    def dataAccessRoleArn: Option[IamRoleArn]
    def targetEventTypes: Option[List[EventTypeString]]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobArn: ZIO[Any, AwsError, ComprehendArn] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getJobName: ZIO[Any, AwsError, JobName] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getMessage: ZIO[Any, AwsError, AnyLengthString] =
      AwsError.unwrapOptionField("message", message)
    def getSubmitTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submitTime", submitTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getInputDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.InputDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField("inputDataConfig", inputDataConfig)
    def getOutputDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.OutputDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField("outputDataConfig", outputDataConfig)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.comprehend.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getDataAccessRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("dataAccessRoleArn", dataAccessRoleArn)
    def getTargetEventTypes: ZIO[Any, AwsError, List[EventTypeString]] =
      AwsError.unwrapOptionField("targetEventTypes", targetEventTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.EventsDetectionJobProperties
  ) extends zio.aws.comprehend.model.EventsDetectionJobProperties.ReadOnly {
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.comprehend.model.primitives.JobId(value))
    override val jobArn: Option[ComprehendArn] = scala
      .Option(impl.jobArn())
      .map(value => zio.aws.comprehend.model.primitives.ComprehendArn(value))
    override val jobName: Option[JobName] = scala
      .Option(impl.jobName())
      .map(value => zio.aws.comprehend.model.primitives.JobName(value))
    override val jobStatus: Option[zio.aws.comprehend.model.JobStatus] = scala
      .Option(impl.jobStatus())
      .map(value => zio.aws.comprehend.model.JobStatus.wrap(value))
    override val message: Option[AnyLengthString] = scala
      .Option(impl.message())
      .map(value => zio.aws.comprehend.model.primitives.AnyLengthString(value))
    override val submitTime: Option[Timestamp] = scala
      .Option(impl.submitTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val inputDataConfig
        : Option[zio.aws.comprehend.model.InputDataConfig.ReadOnly] = scala
      .Option(impl.inputDataConfig())
      .map(value => zio.aws.comprehend.model.InputDataConfig.wrap(value))
    override val outputDataConfig
        : Option[zio.aws.comprehend.model.OutputDataConfig.ReadOnly] = scala
      .Option(impl.outputDataConfig())
      .map(value => zio.aws.comprehend.model.OutputDataConfig.wrap(value))
    override val languageCode: Option[zio.aws.comprehend.model.LanguageCode] =
      scala
        .Option(impl.languageCode())
        .map(value => zio.aws.comprehend.model.LanguageCode.wrap(value))
    override val dataAccessRoleArn: Option[IamRoleArn] = scala
      .Option(impl.dataAccessRoleArn())
      .map(value => zio.aws.comprehend.model.primitives.IamRoleArn(value))
    override val targetEventTypes: Option[List[EventTypeString]] = scala
      .Option(impl.targetEventTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.primitives.EventTypeString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.EventsDetectionJobProperties
  ): zio.aws.comprehend.model.EventsDetectionJobProperties.ReadOnly =
    new Wrapper(impl)
}
