package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.EntityRecognizerArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateEntityRecognizerResponse(
    entityRecognizerArn: Option[EntityRecognizerArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerResponse = {
    import CreateEntityRecognizerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerResponse
      .builder()
      .optionallyWith(
        entityRecognizerArn.map(value =>
          EntityRecognizerArn.unwrap(value): java.lang.String
        )
      )(_.entityRecognizerArn)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.CreateEntityRecognizerResponse.ReadOnly =
    zio.aws.comprehend.model.CreateEntityRecognizerResponse
      .wrap(buildAwsValue())
}
object CreateEntityRecognizerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.CreateEntityRecognizerResponse =
      zio.aws.comprehend.model
        .CreateEntityRecognizerResponse(entityRecognizerArn.map(value => value))
    def entityRecognizerArn: Option[EntityRecognizerArn]
    def getEntityRecognizerArn: ZIO[Any, AwsError, EntityRecognizerArn] =
      AwsError.unwrapOptionField("entityRecognizerArn", entityRecognizerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerResponse
  ) extends zio.aws.comprehend.model.CreateEntityRecognizerResponse.ReadOnly {
    override val entityRecognizerArn: Option[EntityRecognizerArn] = scala
      .Option(impl.entityRecognizerArn())
      .map(value =>
        zio.aws.comprehend.model.primitives.EntityRecognizerArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerResponse
  ): zio.aws.comprehend.model.CreateEntityRecognizerResponse.ReadOnly =
    new Wrapper(impl)
}
