package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListEntityRecognizerSummariesResponse(
    entityRecognizerSummariesList: Option[
      Iterable[zio.aws.comprehend.model.EntityRecognizerSummary]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesResponse = {
    import ListEntityRecognizerSummariesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesResponse
      .builder()
      .optionallyWith(
        entityRecognizerSummariesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entityRecognizerSummariesList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ListEntityRecognizerSummariesResponse.ReadOnly =
    zio.aws.comprehend.model.ListEntityRecognizerSummariesResponse
      .wrap(buildAwsValue())
}
object ListEntityRecognizerSummariesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.ListEntityRecognizerSummariesResponse =
      zio.aws.comprehend.model.ListEntityRecognizerSummariesResponse(
        entityRecognizerSummariesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def entityRecognizerSummariesList: Option[
      List[zio.aws.comprehend.model.EntityRecognizerSummary.ReadOnly]
    ]
    def nextToken: Option[String]
    def getEntityRecognizerSummariesList: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.EntityRecognizerSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "entityRecognizerSummariesList",
      entityRecognizerSummariesList
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesResponse
  ) extends zio.aws.comprehend.model.ListEntityRecognizerSummariesResponse.ReadOnly {
    override val entityRecognizerSummariesList: Option[
      List[zio.aws.comprehend.model.EntityRecognizerSummary.ReadOnly]
    ] = scala
      .Option(impl.entityRecognizerSummariesList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.EntityRecognizerSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesResponse
  ): zio.aws.comprehend.model.ListEntityRecognizerSummariesResponse.ReadOnly =
    new Wrapper(impl)
}
