package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{Timestamp, ComprehendArnName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DocumentClassifierFilter(
    status: Option[zio.aws.comprehend.model.ModelStatus] = None,
    documentClassifierName: Option[ComprehendArnName] = None,
    submitTimeBefore: Option[Timestamp] = None,
    submitTimeAfter: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DocumentClassifierFilter = {
    import DocumentClassifierFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DocumentClassifierFilter
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        documentClassifierName.map(value =>
          ComprehendArnName.unwrap(value): java.lang.String
        )
      )(_.documentClassifierName)
      .optionallyWith(
        submitTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.submitTimeBefore)
      .optionallyWith(
        submitTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.submitTimeAfter)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DocumentClassifierFilter.ReadOnly =
    zio.aws.comprehend.model.DocumentClassifierFilter.wrap(buildAwsValue())
}
object DocumentClassifierFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DocumentClassifierFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DocumentClassifierFilter =
      zio.aws.comprehend.model.DocumentClassifierFilter(
        status.map(value => value),
        documentClassifierName.map(value => value),
        submitTimeBefore.map(value => value),
        submitTimeAfter.map(value => value)
      )
    def status: Option[zio.aws.comprehend.model.ModelStatus]
    def documentClassifierName: Option[ComprehendArnName]
    def submitTimeBefore: Option[Timestamp]
    def submitTimeAfter: Option[Timestamp]
    def getStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.ModelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getDocumentClassifierName: ZIO[Any, AwsError, ComprehendArnName] =
      AwsError.unwrapOptionField(
        "documentClassifierName",
        documentClassifierName
      )
    def getSubmitTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submitTimeBefore", submitTimeBefore)
    def getSubmitTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submitTimeAfter", submitTimeAfter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClassifierFilter
  ) extends zio.aws.comprehend.model.DocumentClassifierFilter.ReadOnly {
    override val status: Option[zio.aws.comprehend.model.ModelStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.comprehend.model.ModelStatus.wrap(value))
    override val documentClassifierName: Option[ComprehendArnName] = scala
      .Option(impl.documentClassifierName())
      .map(value =>
        zio.aws.comprehend.model.primitives.ComprehendArnName(value)
      )
    override val submitTimeBefore: Option[Timestamp] = scala
      .Option(impl.submitTimeBefore())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val submitTimeAfter: Option[Timestamp] = scala
      .Option(impl.submitTimeAfter())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClassifierFilter
  ): zio.aws.comprehend.model.DocumentClassifierFilter.ReadOnly = new Wrapper(
    impl
  )
}
