package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{ComprehendArn, JobId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartDominantLanguageDetectionJobResponse(
    jobId: Option[JobId] = None,
    jobArn: Option[ComprehendArn] = None,
    jobStatus: Option[zio.aws.comprehend.model.JobStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobResponse = {
    import StartDominantLanguageDetectionJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobResponse
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        jobArn.map(value => ComprehendArn.unwrap(value): java.lang.String)
      )(_.jobArn)
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.StartDominantLanguageDetectionJobResponse.ReadOnly =
    zio.aws.comprehend.model.StartDominantLanguageDetectionJobResponse
      .wrap(buildAwsValue())
}
object StartDominantLanguageDetectionJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.StartDominantLanguageDetectionJobResponse =
      zio.aws.comprehend.model.StartDominantLanguageDetectionJobResponse(
        jobId.map(value => value),
        jobArn.map(value => value),
        jobStatus.map(value => value)
      )
    def jobId: Option[JobId]
    def jobArn: Option[ComprehendArn]
    def jobStatus: Option[zio.aws.comprehend.model.JobStatus]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobArn: ZIO[Any, AwsError, ComprehendArn] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobResponse
  ) extends zio.aws.comprehend.model.StartDominantLanguageDetectionJobResponse.ReadOnly {
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.comprehend.model.primitives.JobId(value))
    override val jobArn: Option[ComprehendArn] = scala
      .Option(impl.jobArn())
      .map(value => zio.aws.comprehend.model.primitives.ComprehendArn(value))
    override val jobStatus: Option[zio.aws.comprehend.model.JobStatus] = scala
      .Option(impl.jobStatus())
      .map(value => zio.aws.comprehend.model.JobStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobResponse
  ): zio.aws.comprehend.model.StartDominantLanguageDetectionJobResponse.ReadOnly =
    new Wrapper(impl)
}
