package zio.aws.comprehend.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.comprehend.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class FlywheelFilter(
    status: Optional[zio.aws.comprehend.model.FlywheelStatus] = Optional.Absent,
    creationTimeAfter: Optional[Timestamp] = Optional.Absent,
    creationTimeBefore: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.FlywheelFilter = {
    import FlywheelFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.FlywheelFilter
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.FlywheelFilter.ReadOnly =
    zio.aws.comprehend.model.FlywheelFilter.wrap(buildAwsValue())
}
object FlywheelFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.FlywheelFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.FlywheelFilter =
      zio.aws.comprehend.model.FlywheelFilter(
        status.map(value => value),
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value)
      )
    def status: Optional[zio.aws.comprehend.model.FlywheelStatus]
    def creationTimeAfter: Optional[Timestamp]
    def creationTimeBefore: Optional[Timestamp]
    def getStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.FlywheelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.FlywheelFilter
  ) extends zio.aws.comprehend.model.FlywheelFilter.ReadOnly {
    override val status: Optional[zio.aws.comprehend.model.FlywheelStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.comprehend.model.FlywheelStatus.wrap(value))
    override val creationTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeAfter())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val creationTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeBefore())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.FlywheelFilter
  ): zio.aws.comprehend.model.FlywheelFilter.ReadOnly = new Wrapper(impl)
}
