package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  FlywheelIterationId,
  ComprehendFlywheelArn
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeFlywheelIterationRequest(
    flywheelArn: ComprehendFlywheelArn,
    flywheelIterationId: FlywheelIterationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeFlywheelIterationRequest = {
    import DescribeFlywheelIterationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeFlywheelIterationRequest
      .builder()
      .flywheelArn(ComprehendFlywheelArn.unwrap(flywheelArn): java.lang.String)
      .flywheelIterationId(
        FlywheelIterationId.unwrap(flywheelIterationId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DescribeFlywheelIterationRequest.ReadOnly =
    zio.aws.comprehend.model.DescribeFlywheelIterationRequest
      .wrap(buildAwsValue())
}
object DescribeFlywheelIterationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeFlywheelIterationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DescribeFlywheelIterationRequest =
      zio.aws.comprehend.model
        .DescribeFlywheelIterationRequest(flywheelArn, flywheelIterationId)
    def flywheelArn: ComprehendFlywheelArn
    def flywheelIterationId: FlywheelIterationId
    def getFlywheelArn: ZIO[Any, Nothing, ComprehendFlywheelArn] =
      ZIO.succeed(flywheelArn)
    def getFlywheelIterationId: ZIO[Any, Nothing, FlywheelIterationId] =
      ZIO.succeed(flywheelIterationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeFlywheelIterationRequest
  ) extends zio.aws.comprehend.model.DescribeFlywheelIterationRequest.ReadOnly {
    override val flywheelArn: ComprehendFlywheelArn =
      zio.aws.comprehend.model.primitives
        .ComprehendFlywheelArn(impl.flywheelArn())
    override val flywheelIterationId: FlywheelIterationId =
      zio.aws.comprehend.model.primitives
        .FlywheelIterationId(impl.flywheelIterationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeFlywheelIterationRequest
  ): zio.aws.comprehend.model.DescribeFlywheelIterationRequest.ReadOnly =
    new Wrapper(impl)
}
