package zio.aws.comprehend.model
import scala.jdk.CollectionConverters._
sealed trait ModelType {
  def unwrap: software.amazon.awssdk.services.comprehend.model.ModelType
}
object ModelType {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.ModelType
  ): zio.aws.comprehend.model.ModelType = value match {
    case software.amazon.awssdk.services.comprehend.model.ModelType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.ModelType.DOCUMENT_CLASSIFIER =>
      val r = DOCUMENT_CLASSIFIER
      r
    case software.amazon.awssdk.services.comprehend.model.ModelType.ENTITY_RECOGNIZER =>
      val r = ENTITY_RECOGNIZER
      r
  }
  case object unknownToSdkVersion extends zio.aws.comprehend.model.ModelType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.ModelType =
      software.amazon.awssdk.services.comprehend.model.ModelType.UNKNOWN_TO_SDK_VERSION
  }
  case object DOCUMENT_CLASSIFIER extends zio.aws.comprehend.model.ModelType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.ModelType =
      software.amazon.awssdk.services.comprehend.model.ModelType.DOCUMENT_CLASSIFIER
  }
  case object ENTITY_RECOGNIZER extends zio.aws.comprehend.model.ModelType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.ModelType =
      software.amazon.awssdk.services.comprehend.model.ModelType.ENTITY_RECOGNIZER
  }
}
