package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExtractedCharactersListItem(
    page: Optional[Integer] = Optional.Absent,
    count: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ExtractedCharactersListItem = {
    import ExtractedCharactersListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ExtractedCharactersListItem
      .builder()
      .optionallyWith(page.map(value => value: java.lang.Integer))(_.page)
      .optionallyWith(count.map(value => value: java.lang.Integer))(_.count)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ExtractedCharactersListItem.ReadOnly =
    zio.aws.comprehend.model.ExtractedCharactersListItem.wrap(buildAwsValue())
}
object ExtractedCharactersListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ExtractedCharactersListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ExtractedCharactersListItem =
      zio.aws.comprehend.model.ExtractedCharactersListItem(
        page.map(value => value),
        count.map(value => value)
      )
    def page: Optional[Integer]
    def count: Optional[Integer]
    def getPage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("page", page)
    def getCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("count", count)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ExtractedCharactersListItem
  ) extends zio.aws.comprehend.model.ExtractedCharactersListItem.ReadOnly {
    override val page: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.page())
      .map(value => value: Integer)
    override val count: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ExtractedCharactersListItem
  ): zio.aws.comprehend.model.ExtractedCharactersListItem.ReadOnly =
    new Wrapper(impl)
}
