package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  ComprehendFlywheelArn,
  DocumentClassifierArn,
  ClientRequestTokenString,
  IamRoleArn,
  JobName,
  KmsKeyId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartDocumentClassificationJobRequest(
    jobName: Optional[JobName] = Optional.Absent,
    documentClassifierArn: Optional[DocumentClassifierArn] = Optional.Absent,
    inputDataConfig: zio.aws.comprehend.model.InputDataConfig,
    outputDataConfig: zio.aws.comprehend.model.OutputDataConfig,
    dataAccessRoleArn: IamRoleArn,
    clientRequestToken: Optional[ClientRequestTokenString] = Optional.Absent,
    volumeKmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    vpcConfig: Optional[zio.aws.comprehend.model.VpcConfig] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.comprehend.model.Tag]] = Optional.Absent,
    flywheelArn: Optional[ComprehendFlywheelArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobRequest = {
    import StartDocumentClassificationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobRequest
      .builder()
      .optionallyWith(
        jobName.map(value => JobName.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(
        documentClassifierArn.map(value =>
          DocumentClassifierArn.unwrap(value): java.lang.String
        )
      )(_.documentClassifierArn)
      .inputDataConfig(inputDataConfig.buildAwsValue())
      .outputDataConfig(outputDataConfig.buildAwsValue())
      .dataAccessRoleArn(IamRoleArn.unwrap(dataAccessRoleArn): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestTokenString.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        volumeKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.volumeKmsKeyId)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        flywheelArn.map(value =>
          ComprehendFlywheelArn.unwrap(value): java.lang.String
        )
      )(_.flywheelArn)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.StartDocumentClassificationJobRequest.ReadOnly =
    zio.aws.comprehend.model.StartDocumentClassificationJobRequest
      .wrap(buildAwsValue())
}
object StartDocumentClassificationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.StartDocumentClassificationJobRequest =
      zio.aws.comprehend.model.StartDocumentClassificationJobRequest(
        jobName.map(value => value),
        documentClassifierArn.map(value => value),
        inputDataConfig.asEditable,
        outputDataConfig.asEditable,
        dataAccessRoleArn,
        clientRequestToken.map(value => value),
        volumeKmsKeyId.map(value => value),
        vpcConfig.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        flywheelArn.map(value => value)
      )
    def jobName: Optional[JobName]
    def documentClassifierArn: Optional[DocumentClassifierArn]
    def inputDataConfig: zio.aws.comprehend.model.InputDataConfig.ReadOnly
    def outputDataConfig: zio.aws.comprehend.model.OutputDataConfig.ReadOnly
    def dataAccessRoleArn: IamRoleArn
    def clientRequestToken: Optional[ClientRequestTokenString]
    def volumeKmsKeyId: Optional[KmsKeyId]
    def vpcConfig: Optional[zio.aws.comprehend.model.VpcConfig.ReadOnly]
    def tags: Optional[List[zio.aws.comprehend.model.Tag.ReadOnly]]
    def flywheelArn: Optional[ComprehendFlywheelArn]
    def getJobName: ZIO[Any, AwsError, JobName] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getDocumentClassifierArn: ZIO[Any, AwsError, DocumentClassifierArn] =
      AwsError.unwrapOptionField("documentClassifierArn", documentClassifierArn)
    def getInputDataConfig
        : ZIO[Any, Nothing, zio.aws.comprehend.model.InputDataConfig.ReadOnly] =
      ZIO.succeed(inputDataConfig)
    def getOutputDataConfig: ZIO[
      Any,
      Nothing,
      zio.aws.comprehend.model.OutputDataConfig.ReadOnly
    ] = ZIO.succeed(outputDataConfig)
    def getDataAccessRoleArn: ZIO[Any, Nothing, IamRoleArn] =
      ZIO.succeed(dataAccessRoleArn)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestTokenString] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getVolumeKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("volumeKmsKeyId", volumeKmsKeyId)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.comprehend.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.comprehend.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getFlywheelArn: ZIO[Any, AwsError, ComprehendFlywheelArn] =
      AwsError.unwrapOptionField("flywheelArn", flywheelArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobRequest
  ) extends zio.aws.comprehend.model.StartDocumentClassificationJobRequest.ReadOnly {
    override val jobName: Optional[JobName] = zio.aws.core.internal
      .optionalFromNullable(impl.jobName())
      .map(value => zio.aws.comprehend.model.primitives.JobName(value))
    override val documentClassifierArn: Optional[DocumentClassifierArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentClassifierArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.DocumentClassifierArn(value)
        )
    override val inputDataConfig
        : zio.aws.comprehend.model.InputDataConfig.ReadOnly =
      zio.aws.comprehend.model.InputDataConfig.wrap(impl.inputDataConfig())
    override val outputDataConfig
        : zio.aws.comprehend.model.OutputDataConfig.ReadOnly =
      zio.aws.comprehend.model.OutputDataConfig.wrap(impl.outputDataConfig())
    override val dataAccessRoleArn: IamRoleArn =
      zio.aws.comprehend.model.primitives.IamRoleArn(impl.dataAccessRoleArn())
    override val clientRequestToken: Optional[ClientRequestTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.comprehend.model.primitives.ClientRequestTokenString(value)
        )
    override val volumeKmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeKmsKeyId())
      .map(value => zio.aws.comprehend.model.primitives.KmsKeyId(value))
    override val vpcConfig
        : Optional[zio.aws.comprehend.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.comprehend.model.VpcConfig.wrap(value))
    override val tags: Optional[List[zio.aws.comprehend.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.Tag.wrap(item)
          }.toList
        )
    override val flywheelArn: Optional[ComprehendFlywheelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flywheelArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.ComprehendFlywheelArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobRequest
  ): zio.aws.comprehend.model.StartDocumentClassificationJobRequest.ReadOnly =
    new Wrapper(impl)
}
