package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.DocumentClassifierArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopTrainingDocumentClassifierRequest(
    documentClassifierArn: DocumentClassifierArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.StopTrainingDocumentClassifierRequest = {
    import StopTrainingDocumentClassifierRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.StopTrainingDocumentClassifierRequest
      .builder()
      .documentClassifierArn(
        DocumentClassifierArn.unwrap(documentClassifierArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.StopTrainingDocumentClassifierRequest.ReadOnly =
    zio.aws.comprehend.model.StopTrainingDocumentClassifierRequest
      .wrap(buildAwsValue())
}
object StopTrainingDocumentClassifierRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.StopTrainingDocumentClassifierRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.StopTrainingDocumentClassifierRequest =
      zio.aws.comprehend.model
        .StopTrainingDocumentClassifierRequest(documentClassifierArn)
    def documentClassifierArn: DocumentClassifierArn
    def getDocumentClassifierArn: ZIO[Any, Nothing, DocumentClassifierArn] =
      ZIO.succeed(documentClassifierArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.StopTrainingDocumentClassifierRequest
  ) extends zio.aws.comprehend.model.StopTrainingDocumentClassifierRequest.ReadOnly {
    override val documentClassifierArn: DocumentClassifierArn =
      zio.aws.comprehend.model.primitives
        .DocumentClassifierArn(impl.documentClassifierArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.StopTrainingDocumentClassifierRequest
  ): zio.aws.comprehend.model.StopTrainingDocumentClassifierRequest.ReadOnly =
    new Wrapper(impl)
}
