package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.ComprehendFlywheelArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteFlywheelRequest(flywheelArn: ComprehendFlywheelArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DeleteFlywheelRequest = {
    import DeleteFlywheelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DeleteFlywheelRequest
      .builder()
      .flywheelArn(ComprehendFlywheelArn.unwrap(flywheelArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DeleteFlywheelRequest.ReadOnly =
    zio.aws.comprehend.model.DeleteFlywheelRequest.wrap(buildAwsValue())
}
object DeleteFlywheelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DeleteFlywheelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DeleteFlywheelRequest =
      zio.aws.comprehend.model.DeleteFlywheelRequest(flywheelArn)
    def flywheelArn: ComprehendFlywheelArn
    def getFlywheelArn: ZIO[Any, Nothing, ComprehendFlywheelArn] =
      ZIO.succeed(flywheelArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DeleteFlywheelRequest
  ) extends zio.aws.comprehend.model.DeleteFlywheelRequest.ReadOnly {
    override val flywheelArn: ComprehendFlywheelArn =
      zio.aws.comprehend.model.primitives
        .ComprehendFlywheelArn(impl.flywheelArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DeleteFlywheelRequest
  ): zio.aws.comprehend.model.DeleteFlywheelRequest.ReadOnly = new Wrapper(impl)
}
