package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DatasetInputDataConfig(
    augmentedManifests: Optional[
      Iterable[zio.aws.comprehend.model.DatasetAugmentedManifestsListItem]
    ] = Optional.Absent,
    dataFormat: Optional[zio.aws.comprehend.model.DatasetDataFormat] =
      Optional.Absent,
    documentClassifierInputDataConfig: Optional[
      zio.aws.comprehend.model.DatasetDocumentClassifierInputDataConfig
    ] = Optional.Absent,
    entityRecognizerInputDataConfig: Optional[
      zio.aws.comprehend.model.DatasetEntityRecognizerInputDataConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DatasetInputDataConfig = {
    import DatasetInputDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DatasetInputDataConfig
      .builder()
      .optionallyWith(
        augmentedManifests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.augmentedManifests)
      .optionallyWith(dataFormat.map(value => value.unwrap))(_.dataFormat)
      .optionallyWith(
        documentClassifierInputDataConfig.map(value => value.buildAwsValue())
      )(_.documentClassifierInputDataConfig)
      .optionallyWith(
        entityRecognizerInputDataConfig.map(value => value.buildAwsValue())
      )(_.entityRecognizerInputDataConfig)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DatasetInputDataConfig.ReadOnly =
    zio.aws.comprehend.model.DatasetInputDataConfig.wrap(buildAwsValue())
}
object DatasetInputDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DatasetInputDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DatasetInputDataConfig =
      zio.aws.comprehend.model.DatasetInputDataConfig(
        augmentedManifests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataFormat.map(value => value),
        documentClassifierInputDataConfig.map(value => value.asEditable),
        entityRecognizerInputDataConfig.map(value => value.asEditable)
      )
    def augmentedManifests: Optional[
      List[zio.aws.comprehend.model.DatasetAugmentedManifestsListItem.ReadOnly]
    ]
    def dataFormat: Optional[zio.aws.comprehend.model.DatasetDataFormat]
    def documentClassifierInputDataConfig: Optional[
      zio.aws.comprehend.model.DatasetDocumentClassifierInputDataConfig.ReadOnly
    ]
    def entityRecognizerInputDataConfig: Optional[
      zio.aws.comprehend.model.DatasetEntityRecognizerInputDataConfig.ReadOnly
    ]
    def getAugmentedManifests: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.DatasetAugmentedManifestsListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("augmentedManifests", augmentedManifests)
    def getDataFormat
        : ZIO[Any, AwsError, zio.aws.comprehend.model.DatasetDataFormat] =
      AwsError.unwrapOptionField("dataFormat", dataFormat)
    def getDocumentClassifierInputDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DatasetDocumentClassifierInputDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "documentClassifierInputDataConfig",
      documentClassifierInputDataConfig
    )
    def getEntityRecognizerInputDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DatasetEntityRecognizerInputDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "entityRecognizerInputDataConfig",
      entityRecognizerInputDataConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DatasetInputDataConfig
  ) extends zio.aws.comprehend.model.DatasetInputDataConfig.ReadOnly {
    override val augmentedManifests: Optional[
      List[zio.aws.comprehend.model.DatasetAugmentedManifestsListItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.augmentedManifests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.DatasetAugmentedManifestsListItem.wrap(item)
        }.toList
      )
    override val dataFormat
        : Optional[zio.aws.comprehend.model.DatasetDataFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataFormat())
        .map(value => zio.aws.comprehend.model.DatasetDataFormat.wrap(value))
    override val documentClassifierInputDataConfig: Optional[
      zio.aws.comprehend.model.DatasetDocumentClassifierInputDataConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.documentClassifierInputDataConfig())
      .map(value =>
        zio.aws.comprehend.model.DatasetDocumentClassifierInputDataConfig
          .wrap(value)
      )
    override val entityRecognizerInputDataConfig: Optional[
      zio.aws.comprehend.model.DatasetEntityRecognizerInputDataConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.entityRecognizerInputDataConfig())
      .map(value =>
        zio.aws.comprehend.model.DatasetEntityRecognizerInputDataConfig
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DatasetInputDataConfig
  ): zio.aws.comprehend.model.DatasetInputDataConfig.ReadOnly = new Wrapper(
    impl
  )
}
