package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DatasetEntityRecognizerInputDataConfig(
    annotations: Optional[
      zio.aws.comprehend.model.DatasetEntityRecognizerAnnotations
    ] = Optional.Absent,
    documents: zio.aws.comprehend.model.DatasetEntityRecognizerDocuments,
    entityList: Optional[
      zio.aws.comprehend.model.DatasetEntityRecognizerEntityList
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DatasetEntityRecognizerInputDataConfig = {
    import DatasetEntityRecognizerInputDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DatasetEntityRecognizerInputDataConfig
      .builder()
      .optionallyWith(annotations.map(value => value.buildAwsValue()))(
        _.annotations
      )
      .documents(documents.buildAwsValue())
      .optionallyWith(entityList.map(value => value.buildAwsValue()))(
        _.entityList
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DatasetEntityRecognizerInputDataConfig.ReadOnly =
    zio.aws.comprehend.model.DatasetEntityRecognizerInputDataConfig
      .wrap(buildAwsValue())
}
object DatasetEntityRecognizerInputDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DatasetEntityRecognizerInputDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.DatasetEntityRecognizerInputDataConfig =
      zio.aws.comprehend.model.DatasetEntityRecognizerInputDataConfig(
        annotations.map(value => value.asEditable),
        documents.asEditable,
        entityList.map(value => value.asEditable)
      )
    def annotations: Optional[
      zio.aws.comprehend.model.DatasetEntityRecognizerAnnotations.ReadOnly
    ]
    def documents
        : zio.aws.comprehend.model.DatasetEntityRecognizerDocuments.ReadOnly
    def entityList: Optional[
      zio.aws.comprehend.model.DatasetEntityRecognizerEntityList.ReadOnly
    ]
    def getAnnotations: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DatasetEntityRecognizerAnnotations.ReadOnly
    ] = AwsError.unwrapOptionField("annotations", annotations)
    def getDocuments: ZIO[
      Any,
      Nothing,
      zio.aws.comprehend.model.DatasetEntityRecognizerDocuments.ReadOnly
    ] = ZIO.succeed(documents)
    def getEntityList: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DatasetEntityRecognizerEntityList.ReadOnly
    ] = AwsError.unwrapOptionField("entityList", entityList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DatasetEntityRecognizerInputDataConfig
  ) extends zio.aws.comprehend.model.DatasetEntityRecognizerInputDataConfig.ReadOnly {
    override val annotations: Optional[
      zio.aws.comprehend.model.DatasetEntityRecognizerAnnotations.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.annotations())
      .map(value =>
        zio.aws.comprehend.model.DatasetEntityRecognizerAnnotations.wrap(value)
      )
    override val documents
        : zio.aws.comprehend.model.DatasetEntityRecognizerDocuments.ReadOnly =
      zio.aws.comprehend.model.DatasetEntityRecognizerDocuments
        .wrap(impl.documents())
    override val entityList: Optional[
      zio.aws.comprehend.model.DatasetEntityRecognizerEntityList.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.entityList())
      .map(value =>
        zio.aws.comprehend.model.DatasetEntityRecognizerEntityList.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DatasetEntityRecognizerInputDataConfig
  ): zio.aws.comprehend.model.DatasetEntityRecognizerInputDataConfig.ReadOnly =
    new Wrapper(impl)
}
