package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PiiEntity(
    score: Optional[Float] = Optional.Absent,
    `type`: Optional[zio.aws.comprehend.model.PiiEntityType] = Optional.Absent,
    beginOffset: Optional[Integer] = Optional.Absent,
    endOffset: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.PiiEntity = {
    import PiiEntity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.PiiEntity
      .builder()
      .optionallyWith(score.map(value => value: java.lang.Float))(_.score)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(beginOffset.map(value => value: java.lang.Integer))(
        _.beginOffset
      )
      .optionallyWith(endOffset.map(value => value: java.lang.Integer))(
        _.endOffset
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.PiiEntity.ReadOnly =
    zio.aws.comprehend.model.PiiEntity.wrap(buildAwsValue())
}
object PiiEntity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.PiiEntity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.PiiEntity =
      zio.aws.comprehend.model.PiiEntity(
        score.map(value => value),
        `type`.map(value => value),
        beginOffset.map(value => value),
        endOffset.map(value => value)
      )
    def score: Optional[Float]
    def `type`: Optional[zio.aws.comprehend.model.PiiEntityType]
    def beginOffset: Optional[Integer]
    def endOffset: Optional[Integer]
    def getScore: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("score", score)
    def getType: ZIO[Any, AwsError, zio.aws.comprehend.model.PiiEntityType] =
      AwsError.unwrapOptionField("type", `type`)
    def getBeginOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("beginOffset", beginOffset)
    def getEndOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("endOffset", endOffset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.PiiEntity
  ) extends zio.aws.comprehend.model.PiiEntity.ReadOnly {
    override val score: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.score())
      .map(value => value: Float)
    override val `type`: Optional[zio.aws.comprehend.model.PiiEntityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.comprehend.model.PiiEntityType.wrap(value))
    override val beginOffset: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.beginOffset())
      .map(value => value: Integer)
    override val endOffset: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.endOffset())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.PiiEntity
  ): zio.aws.comprehend.model.PiiEntity.ReadOnly = new Wrapper(impl)
}
