package zio.aws.comprehend.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.comprehend.model.primitives.{Timestamp, ComprehendArnName}
import scala.jdk.CollectionConverters._
final case class DocumentClassifierFilter(
    status: Optional[zio.aws.comprehend.model.ModelStatus] = Optional.Absent,
    documentClassifierName: Optional[ComprehendArnName] = Optional.Absent,
    submitTimeBefore: Optional[Timestamp] = Optional.Absent,
    submitTimeAfter: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DocumentClassifierFilter = {
    import DocumentClassifierFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DocumentClassifierFilter
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        documentClassifierName.map(value =>
          ComprehendArnName.unwrap(value): java.lang.String
        )
      )(_.documentClassifierName)
      .optionallyWith(
        submitTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.submitTimeBefore)
      .optionallyWith(
        submitTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.submitTimeAfter)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DocumentClassifierFilter.ReadOnly =
    zio.aws.comprehend.model.DocumentClassifierFilter.wrap(buildAwsValue())
}
object DocumentClassifierFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DocumentClassifierFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DocumentClassifierFilter =
      zio.aws.comprehend.model.DocumentClassifierFilter(
        status.map(value => value),
        documentClassifierName.map(value => value),
        submitTimeBefore.map(value => value),
        submitTimeAfter.map(value => value)
      )
    def status: Optional[zio.aws.comprehend.model.ModelStatus]
    def documentClassifierName: Optional[ComprehendArnName]
    def submitTimeBefore: Optional[Timestamp]
    def submitTimeAfter: Optional[Timestamp]
    def getStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.ModelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getDocumentClassifierName: ZIO[Any, AwsError, ComprehendArnName] =
      AwsError.unwrapOptionField(
        "documentClassifierName",
        documentClassifierName
      )
    def getSubmitTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submitTimeBefore", submitTimeBefore)
    def getSubmitTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submitTimeAfter", submitTimeAfter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClassifierFilter
  ) extends zio.aws.comprehend.model.DocumentClassifierFilter.ReadOnly {
    override val status: Optional[zio.aws.comprehend.model.ModelStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.comprehend.model.ModelStatus.wrap(value))
    override val documentClassifierName: Optional[ComprehendArnName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentClassifierName())
        .map(value =>
          zio.aws.comprehend.model.primitives.ComprehendArnName(value)
        )
    override val submitTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.submitTimeBefore())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val submitTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.submitTimeAfter())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClassifierFilter
  ): zio.aws.comprehend.model.DocumentClassifierFilter.ReadOnly = new Wrapper(
    impl
  )
}
