package zio.aws.comprehend.model
import scala.jdk.CollectionConverters._
sealed trait DocumentClassifierDocumentTypeFormat {
  def unwrap: software.amazon.awssdk.services.comprehend.model.DocumentClassifierDocumentTypeFormat
}
object DocumentClassifierDocumentTypeFormat {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.DocumentClassifierDocumentTypeFormat
  ): zio.aws.comprehend.model.DocumentClassifierDocumentTypeFormat =
    value match {
      case software.amazon.awssdk.services.comprehend.model.DocumentClassifierDocumentTypeFormat.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.comprehend.model.DocumentClassifierDocumentTypeFormat.PLAIN_TEXT_DOCUMENT =>
        val r = PLAIN_TEXT_DOCUMENT
        r
      case software.amazon.awssdk.services.comprehend.model.DocumentClassifierDocumentTypeFormat.SEMI_STRUCTURED_DOCUMENT =>
        val r = SEMI_STRUCTURED_DOCUMENT
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.comprehend.model.DocumentClassifierDocumentTypeFormat {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentClassifierDocumentTypeFormat =
      software.amazon.awssdk.services.comprehend.model.DocumentClassifierDocumentTypeFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object PLAIN_TEXT_DOCUMENT
      extends zio.aws.comprehend.model.DocumentClassifierDocumentTypeFormat {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentClassifierDocumentTypeFormat =
      software.amazon.awssdk.services.comprehend.model.DocumentClassifierDocumentTypeFormat.PLAIN_TEXT_DOCUMENT
  }
  case object SEMI_STRUCTURED_DOCUMENT
      extends zio.aws.comprehend.model.DocumentClassifierDocumentTypeFormat {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentClassifierDocumentTypeFormat =
      software.amazon.awssdk.services.comprehend.model.DocumentClassifierDocumentTypeFormat.SEMI_STRUCTURED_DOCUMENT
  }
}
