package zio.aws.comprehend.model
import scala.jdk.CollectionConverters._
sealed trait JobStatus {
  def unwrap: software.amazon.awssdk.services.comprehend.model.JobStatus
}
object JobStatus {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.JobStatus
  ): zio.aws.comprehend.model.JobStatus = value match {
    case software.amazon.awssdk.services.comprehend.model.JobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.JobStatus.SUBMITTED =>
      val r = SUBMITTED
      r
    case software.amazon.awssdk.services.comprehend.model.JobStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.comprehend.model.JobStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.comprehend.model.JobStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.comprehend.model.JobStatus.STOP_REQUESTED =>
      val r = STOP_REQUESTED
      r
    case software.amazon.awssdk.services.comprehend.model.JobStatus.STOPPED =>
      val r = STOPPED
      r
  }
  case object unknownToSdkVersion extends zio.aws.comprehend.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.JobStatus =
      software.amazon.awssdk.services.comprehend.model.JobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUBMITTED extends zio.aws.comprehend.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.JobStatus =
      software.amazon.awssdk.services.comprehend.model.JobStatus.SUBMITTED
  }
  case object IN_PROGRESS extends zio.aws.comprehend.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.JobStatus =
      software.amazon.awssdk.services.comprehend.model.JobStatus.IN_PROGRESS
  }
  case object COMPLETED extends zio.aws.comprehend.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.JobStatus =
      software.amazon.awssdk.services.comprehend.model.JobStatus.COMPLETED
  }
  case object FAILED extends zio.aws.comprehend.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.JobStatus =
      software.amazon.awssdk.services.comprehend.model.JobStatus.FAILED
  }
  case object STOP_REQUESTED extends zio.aws.comprehend.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.JobStatus =
      software.amazon.awssdk.services.comprehend.model.JobStatus.STOP_REQUESTED
  }
  case object STOPPED extends zio.aws.comprehend.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.JobStatus =
      software.amazon.awssdk.services.comprehend.model.JobStatus.STOPPED
  }
}
