package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.S3Uri
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EntityRecognizerOutputDataConfig(
    flywheelStatsS3Prefix: Optional[S3Uri] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.EntityRecognizerOutputDataConfig = {
    import EntityRecognizerOutputDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerOutputDataConfig
      .builder()
      .optionallyWith(
        flywheelStatsS3Prefix.map(value =>
          S3Uri.unwrap(value): java.lang.String
        )
      )(_.flywheelStatsS3Prefix)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.EntityRecognizerOutputDataConfig.ReadOnly =
    zio.aws.comprehend.model.EntityRecognizerOutputDataConfig
      .wrap(buildAwsValue())
}
object EntityRecognizerOutputDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerOutputDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.EntityRecognizerOutputDataConfig =
      zio.aws.comprehend.model.EntityRecognizerOutputDataConfig(
        flywheelStatsS3Prefix.map(value => value)
      )
    def flywheelStatsS3Prefix: Optional[S3Uri]
    def getFlywheelStatsS3Prefix: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("flywheelStatsS3Prefix", flywheelStatsS3Prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerOutputDataConfig
  ) extends zio.aws.comprehend.model.EntityRecognizerOutputDataConfig.ReadOnly {
    override val flywheelStatsS3Prefix: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.flywheelStatsS3Prefix())
      .map(value => zio.aws.comprehend.model.primitives.S3Uri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerOutputDataConfig
  ): zio.aws.comprehend.model.EntityRecognizerOutputDataConfig.ReadOnly =
    new Wrapper(impl)
}
