package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeFlywheelResponse(
    flywheelProperties: Optional[zio.aws.comprehend.model.FlywheelProperties] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeFlywheelResponse = {
    import DescribeFlywheelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeFlywheelResponse
      .builder()
      .optionallyWith(flywheelProperties.map(value => value.buildAwsValue()))(
        _.flywheelProperties
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DescribeFlywheelResponse.ReadOnly =
    zio.aws.comprehend.model.DescribeFlywheelResponse.wrap(buildAwsValue())
}
object DescribeFlywheelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeFlywheelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DescribeFlywheelResponse =
      zio.aws.comprehend.model.DescribeFlywheelResponse(
        flywheelProperties.map(value => value.asEditable)
      )
    def flywheelProperties
        : Optional[zio.aws.comprehend.model.FlywheelProperties.ReadOnly]
    def getFlywheelProperties: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.FlywheelProperties.ReadOnly
    ] = AwsError.unwrapOptionField("flywheelProperties", flywheelProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeFlywheelResponse
  ) extends zio.aws.comprehend.model.DescribeFlywheelResponse.ReadOnly {
    override val flywheelProperties
        : Optional[zio.aws.comprehend.model.FlywheelProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flywheelProperties())
        .map(value => zio.aws.comprehend.model.FlywheelProperties.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeFlywheelResponse
  ): zio.aws.comprehend.model.DescribeFlywheelResponse.ReadOnly = new Wrapper(
    impl
  )
}
