package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DocumentTypeListItem(
    page: Optional[Integer] = Optional.Absent,
    `type`: Optional[zio.aws.comprehend.model.DocumentType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DocumentTypeListItem = {
    import DocumentTypeListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DocumentTypeListItem
      .builder()
      .optionallyWith(page.map(value => value: java.lang.Integer))(_.page)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DocumentTypeListItem.ReadOnly =
    zio.aws.comprehend.model.DocumentTypeListItem.wrap(buildAwsValue())
}
object DocumentTypeListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DocumentTypeListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DocumentTypeListItem =
      zio.aws.comprehend.model.DocumentTypeListItem(
        page.map(value => value),
        `type`.map(value => value)
      )
    def page: Optional[Integer]
    def `type`: Optional[zio.aws.comprehend.model.DocumentType]
    def getPage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("page", page)
    def getType: ZIO[Any, AwsError, zio.aws.comprehend.model.DocumentType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentTypeListItem
  ) extends zio.aws.comprehend.model.DocumentTypeListItem.ReadOnly {
    override val page: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.page())
      .map(value => value: Integer)
    override val `type`: Optional[zio.aws.comprehend.model.DocumentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.comprehend.model.DocumentType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentTypeListItem
  ): zio.aws.comprehend.model.DocumentTypeListItem.ReadOnly = new Wrapper(impl)
}
