package zio.aws.comprehend.model
import scala.jdk.CollectionConverters._
sealed trait EntityRecognizerDataFormat {
  def unwrap: software.amazon.awssdk.services.comprehend.model.EntityRecognizerDataFormat
}
object EntityRecognizerDataFormat {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.EntityRecognizerDataFormat
  ): zio.aws.comprehend.model.EntityRecognizerDataFormat = value match {
    case software.amazon.awssdk.services.comprehend.model.EntityRecognizerDataFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.EntityRecognizerDataFormat.COMPREHEND_CSV =>
      val r = COMPREHEND_CSV
      r
    case software.amazon.awssdk.services.comprehend.model.EntityRecognizerDataFormat.AUGMENTED_MANIFEST =>
      val r = AUGMENTED_MANIFEST
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.comprehend.model.EntityRecognizerDataFormat {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.EntityRecognizerDataFormat =
      software.amazon.awssdk.services.comprehend.model.EntityRecognizerDataFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPREHEND_CSV
      extends zio.aws.comprehend.model.EntityRecognizerDataFormat {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.EntityRecognizerDataFormat =
      software.amazon.awssdk.services.comprehend.model.EntityRecognizerDataFormat.COMPREHEND_CSV
  }
  case object AUGMENTED_MANIFEST
      extends zio.aws.comprehend.model.EntityRecognizerDataFormat {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.EntityRecognizerDataFormat =
      software.amazon.awssdk.services.comprehend.model.EntityRecognizerDataFormat.AUGMENTED_MANIFEST
  }
}
