package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.S3Uri
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DatasetEntityRecognizerAnnotations(s3Uri: S3Uri) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DatasetEntityRecognizerAnnotations = {
    import DatasetEntityRecognizerAnnotations.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DatasetEntityRecognizerAnnotations
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DatasetEntityRecognizerAnnotations.ReadOnly =
    zio.aws.comprehend.model.DatasetEntityRecognizerAnnotations
      .wrap(buildAwsValue())
}
object DatasetEntityRecognizerAnnotations {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DatasetEntityRecognizerAnnotations
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.DatasetEntityRecognizerAnnotations =
      zio.aws.comprehend.model.DatasetEntityRecognizerAnnotations(s3Uri)
    def s3Uri: S3Uri
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DatasetEntityRecognizerAnnotations
  ) extends zio.aws.comprehend.model.DatasetEntityRecognizerAnnotations.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.comprehend.model.primitives.S3Uri(impl.s3Uri())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DatasetEntityRecognizerAnnotations
  ): zio.aws.comprehend.model.DatasetEntityRecognizerAnnotations.ReadOnly =
    new Wrapper(impl)
}
