package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTargetedSentimentDetectionJobsResponse(
    targetedSentimentDetectionJobPropertiesList: Optional[
      Iterable[zio.aws.comprehend.model.TargetedSentimentDetectionJobProperties]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListTargetedSentimentDetectionJobsResponse = {
    import ListTargetedSentimentDetectionJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListTargetedSentimentDetectionJobsResponse
      .builder()
      .optionallyWith(
        targetedSentimentDetectionJobPropertiesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetedSentimentDetectionJobPropertiesList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ListTargetedSentimentDetectionJobsResponse.ReadOnly =
    zio.aws.comprehend.model.ListTargetedSentimentDetectionJobsResponse
      .wrap(buildAwsValue())
}
object ListTargetedSentimentDetectionJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListTargetedSentimentDetectionJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.ListTargetedSentimentDetectionJobsResponse =
      zio.aws.comprehend.model.ListTargetedSentimentDetectionJobsResponse(
        targetedSentimentDetectionJobPropertiesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def targetedSentimentDetectionJobPropertiesList: Optional[List[
      zio.aws.comprehend.model.TargetedSentimentDetectionJobProperties.ReadOnly
    ]]
    def nextToken: Optional[String]
    def getTargetedSentimentDetectionJobPropertiesList: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.TargetedSentimentDetectionJobProperties.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "targetedSentimentDetectionJobPropertiesList",
      targetedSentimentDetectionJobPropertiesList
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListTargetedSentimentDetectionJobsResponse
  ) extends zio.aws.comprehend.model.ListTargetedSentimentDetectionJobsResponse.ReadOnly {
    override val targetedSentimentDetectionJobPropertiesList: Optional[List[
      zio.aws.comprehend.model.TargetedSentimentDetectionJobProperties.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.targetedSentimentDetectionJobPropertiesList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.TargetedSentimentDetectionJobProperties
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListTargetedSentimentDetectionJobsResponse
  ): zio.aws.comprehend.model.ListTargetedSentimentDetectionJobsResponse.ReadOnly =
    new Wrapper(impl)
}
