package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  ComprehendArnName,
  ClientRequestTokenString,
  IamRoleArn,
  ComprehendModelArn,
  FlywheelS3Uri
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateFlywheelRequest(
    flywheelName: ComprehendArnName,
    activeModelArn: Optional[ComprehendModelArn] = Optional.Absent,
    dataAccessRoleArn: IamRoleArn,
    taskConfig: Optional[zio.aws.comprehend.model.TaskConfig] = Optional.Absent,
    modelType: Optional[zio.aws.comprehend.model.ModelType] = Optional.Absent,
    dataLakeS3Uri: FlywheelS3Uri,
    dataSecurityConfig: Optional[zio.aws.comprehend.model.DataSecurityConfig] =
      Optional.Absent,
    clientRequestToken: Optional[ClientRequestTokenString] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.comprehend.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.CreateFlywheelRequest = {
    import CreateFlywheelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.CreateFlywheelRequest
      .builder()
      .flywheelName(ComprehendArnName.unwrap(flywheelName): java.lang.String)
      .optionallyWith(
        activeModelArn.map(value =>
          ComprehendModelArn.unwrap(value): java.lang.String
        )
      )(_.activeModelArn)
      .dataAccessRoleArn(IamRoleArn.unwrap(dataAccessRoleArn): java.lang.String)
      .optionallyWith(taskConfig.map(value => value.buildAwsValue()))(
        _.taskConfig
      )
      .optionallyWith(modelType.map(value => value.unwrap))(_.modelType)
      .dataLakeS3Uri(FlywheelS3Uri.unwrap(dataLakeS3Uri): java.lang.String)
      .optionallyWith(dataSecurityConfig.map(value => value.buildAwsValue()))(
        _.dataSecurityConfig
      )
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestTokenString.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.CreateFlywheelRequest.ReadOnly =
    zio.aws.comprehend.model.CreateFlywheelRequest.wrap(buildAwsValue())
}
object CreateFlywheelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.CreateFlywheelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.CreateFlywheelRequest =
      zio.aws.comprehend.model.CreateFlywheelRequest(
        flywheelName,
        activeModelArn.map(value => value),
        dataAccessRoleArn,
        taskConfig.map(value => value.asEditable),
        modelType.map(value => value),
        dataLakeS3Uri,
        dataSecurityConfig.map(value => value.asEditable),
        clientRequestToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def flywheelName: ComprehendArnName
    def activeModelArn: Optional[ComprehendModelArn]
    def dataAccessRoleArn: IamRoleArn
    def taskConfig: Optional[zio.aws.comprehend.model.TaskConfig.ReadOnly]
    def modelType: Optional[zio.aws.comprehend.model.ModelType]
    def dataLakeS3Uri: FlywheelS3Uri
    def dataSecurityConfig
        : Optional[zio.aws.comprehend.model.DataSecurityConfig.ReadOnly]
    def clientRequestToken: Optional[ClientRequestTokenString]
    def tags: Optional[List[zio.aws.comprehend.model.Tag.ReadOnly]]
    def getFlywheelName: ZIO[Any, Nothing, ComprehendArnName] =
      ZIO.succeed(flywheelName)
    def getActiveModelArn: ZIO[Any, AwsError, ComprehendModelArn] =
      AwsError.unwrapOptionField("activeModelArn", activeModelArn)
    def getDataAccessRoleArn: ZIO[Any, Nothing, IamRoleArn] =
      ZIO.succeed(dataAccessRoleArn)
    def getTaskConfig
        : ZIO[Any, AwsError, zio.aws.comprehend.model.TaskConfig.ReadOnly] =
      AwsError.unwrapOptionField("taskConfig", taskConfig)
    def getModelType: ZIO[Any, AwsError, zio.aws.comprehend.model.ModelType] =
      AwsError.unwrapOptionField("modelType", modelType)
    def getDataLakeS3Uri: ZIO[Any, Nothing, FlywheelS3Uri] =
      ZIO.succeed(dataLakeS3Uri)
    def getDataSecurityConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DataSecurityConfig.ReadOnly
    ] = AwsError.unwrapOptionField("dataSecurityConfig", dataSecurityConfig)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestTokenString] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.comprehend.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.CreateFlywheelRequest
  ) extends zio.aws.comprehend.model.CreateFlywheelRequest.ReadOnly {
    override val flywheelName: ComprehendArnName =
      zio.aws.comprehend.model.primitives.ComprehendArnName(impl.flywheelName())
    override val activeModelArn: Optional[ComprehendModelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeModelArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.ComprehendModelArn(value)
        )
    override val dataAccessRoleArn: IamRoleArn =
      zio.aws.comprehend.model.primitives.IamRoleArn(impl.dataAccessRoleArn())
    override val taskConfig
        : Optional[zio.aws.comprehend.model.TaskConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskConfig())
        .map(value => zio.aws.comprehend.model.TaskConfig.wrap(value))
    override val modelType: Optional[zio.aws.comprehend.model.ModelType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelType())
        .map(value => zio.aws.comprehend.model.ModelType.wrap(value))
    override val dataLakeS3Uri: FlywheelS3Uri =
      zio.aws.comprehend.model.primitives.FlywheelS3Uri(impl.dataLakeS3Uri())
    override val dataSecurityConfig
        : Optional[zio.aws.comprehend.model.DataSecurityConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSecurityConfig())
        .map(value => zio.aws.comprehend.model.DataSecurityConfig.wrap(value))
    override val clientRequestToken: Optional[ClientRequestTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.comprehend.model.primitives.ClientRequestTokenString(value)
        )
    override val tags: Optional[List[zio.aws.comprehend.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.CreateFlywheelRequest
  ): zio.aws.comprehend.model.CreateFlywheelRequest.ReadOnly = new Wrapper(impl)
}
