package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{TagKey, ComprehendArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: ComprehendArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.UntagResourceRequest
      .builder()
      .resourceArn(ComprehendArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.UntagResourceRequest.ReadOnly =
    zio.aws.comprehend.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.UntagResourceRequest =
      zio.aws.comprehend.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: ComprehendArn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, ComprehendArn] =
      ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.UntagResourceRequest
  ) extends zio.aws.comprehend.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: ComprehendArn =
      zio.aws.comprehend.model.primitives.ComprehendArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.comprehend.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.UntagResourceRequest
  ): zio.aws.comprehend.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
