package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchDetectSyntaxItemResult(
    index: Optional[Integer] = Optional.Absent,
    syntaxTokens: Optional[Iterable[zio.aws.comprehend.model.SyntaxToken]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxItemResult = {
    import BatchDetectSyntaxItemResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxItemResult
      .builder()
      .optionallyWith(index.map(value => value: java.lang.Integer))(_.index)
      .optionallyWith(
        syntaxTokens.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.syntaxTokens)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.BatchDetectSyntaxItemResult.ReadOnly =
    zio.aws.comprehend.model.BatchDetectSyntaxItemResult.wrap(buildAwsValue())
}
object BatchDetectSyntaxItemResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxItemResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.BatchDetectSyntaxItemResult =
      zio.aws.comprehend.model.BatchDetectSyntaxItemResult(
        index.map(value => value),
        syntaxTokens.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def index: Optional[Integer]
    def syntaxTokens
        : Optional[List[zio.aws.comprehend.model.SyntaxToken.ReadOnly]]
    def getIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("index", index)
    def getSyntaxTokens: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.SyntaxToken.ReadOnly
    ]] = AwsError.unwrapOptionField("syntaxTokens", syntaxTokens)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxItemResult
  ) extends zio.aws.comprehend.model.BatchDetectSyntaxItemResult.ReadOnly {
    override val index: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.index())
      .map(value => value: Integer)
    override val syntaxTokens
        : Optional[List[zio.aws.comprehend.model.SyntaxToken.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.syntaxTokens())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.SyntaxToken.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxItemResult
  ): zio.aws.comprehend.model.BatchDetectSyntaxItemResult.ReadOnly =
    new Wrapper(impl)
}
