package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Tag(key: TagKey, value: Optional[TagValue] = Optional.Absent) {
  def buildAwsValue(): software.amazon.awssdk.services.comprehend.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.Tag
      .builder()
      .key(TagKey.unwrap(key): java.lang.String)
      .optionallyWith(
        value.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.Tag.ReadOnly =
    zio.aws.comprehend.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.comprehend.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.Tag =
      zio.aws.comprehend.model.Tag(key, value.map(value => value))
    def key: TagKey
    def value: Optional[TagValue]
    def getKey: ZIO[Any, Nothing, TagKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.Tag
  ) extends zio.aws.comprehend.model.Tag.ReadOnly {
    override val key: TagKey =
      zio.aws.comprehend.model.primitives.TagKey(impl.key())
    override val value: Optional[TagValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.comprehend.model.primitives.TagValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.Tag
  ): zio.aws.comprehend.model.Tag.ReadOnly = new Wrapper(impl)
}
