package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopEntitiesDetectionJobRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.StopEntitiesDetectionJobRequest = {
    import StopEntitiesDetectionJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.StopEntitiesDetectionJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.StopEntitiesDetectionJobRequest.ReadOnly =
    zio.aws.comprehend.model.StopEntitiesDetectionJobRequest
      .wrap(buildAwsValue())
}
object StopEntitiesDetectionJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.StopEntitiesDetectionJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.StopEntitiesDetectionJobRequest =
      zio.aws.comprehend.model.StopEntitiesDetectionJobRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.StopEntitiesDetectionJobRequest
  ) extends zio.aws.comprehend.model.StopEntitiesDetectionJobRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.comprehend.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.StopEntitiesDetectionJobRequest
  ): zio.aws.comprehend.model.StopEntitiesDetectionJobRequest.ReadOnly =
    new Wrapper(impl)
}
