package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.ComprehendModelArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportModelResponse(
    modelArn: Optional[ComprehendModelArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ImportModelResponse = {
    import ImportModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ImportModelResponse
      .builder()
      .optionallyWith(
        modelArn.map(value =>
          ComprehendModelArn.unwrap(value): java.lang.String
        )
      )(_.modelArn)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.ImportModelResponse.ReadOnly =
    zio.aws.comprehend.model.ImportModelResponse.wrap(buildAwsValue())
}
object ImportModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ImportModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ImportModelResponse =
      zio.aws.comprehend.model.ImportModelResponse(modelArn.map(value => value))
    def modelArn: Optional[ComprehendModelArn]
    def getModelArn: ZIO[Any, AwsError, ComprehendModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ImportModelResponse
  ) extends zio.aws.comprehend.model.ImportModelResponse.ReadOnly {
    override val modelArn: Optional[ComprehendModelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelArn())
      .map(value =>
        zio.aws.comprehend.model.primitives.ComprehendModelArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ImportModelResponse
  ): zio.aws.comprehend.model.ImportModelResponse.ReadOnly = new Wrapper(impl)
}
