package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopKeyPhrasesDetectionJobRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.StopKeyPhrasesDetectionJobRequest = {
    import StopKeyPhrasesDetectionJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.StopKeyPhrasesDetectionJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.StopKeyPhrasesDetectionJobRequest.ReadOnly =
    zio.aws.comprehend.model.StopKeyPhrasesDetectionJobRequest
      .wrap(buildAwsValue())
}
object StopKeyPhrasesDetectionJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.StopKeyPhrasesDetectionJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.StopKeyPhrasesDetectionJobRequest =
      zio.aws.comprehend.model.StopKeyPhrasesDetectionJobRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.StopKeyPhrasesDetectionJobRequest
  ) extends zio.aws.comprehend.model.StopKeyPhrasesDetectionJobRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.comprehend.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.StopKeyPhrasesDetectionJobRequest
  ): zio.aws.comprehend.model.StopKeyPhrasesDetectionJobRequest.ReadOnly =
    new Wrapper(impl)
}
