package zio.aws.comprehend.model
import scala.jdk.CollectionConverters._
sealed trait EntityType {
  def unwrap: software.amazon.awssdk.services.comprehend.model.EntityType
}
object EntityType {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.EntityType
  ): zio.aws.comprehend.model.EntityType = value match {
    case software.amazon.awssdk.services.comprehend.model.EntityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.EntityType.PERSON =>
      val r = PERSON
      r
    case software.amazon.awssdk.services.comprehend.model.EntityType.LOCATION =>
      val r = LOCATION
      r
    case software.amazon.awssdk.services.comprehend.model.EntityType.ORGANIZATION =>
      val r = ORGANIZATION
      r
    case software.amazon.awssdk.services.comprehend.model.EntityType.COMMERCIAL_ITEM =>
      val r = COMMERCIAL_ITEM
      r
    case software.amazon.awssdk.services.comprehend.model.EntityType.EVENT =>
      val r = EVENT
      r
    case software.amazon.awssdk.services.comprehend.model.EntityType.DATE =>
      val r = DATE
      r
    case software.amazon.awssdk.services.comprehend.model.EntityType.QUANTITY =>
      val r = QUANTITY
      r
    case software.amazon.awssdk.services.comprehend.model.EntityType.TITLE =>
      val r = TITLE
      r
    case software.amazon.awssdk.services.comprehend.model.EntityType.OTHER =>
      val r = OTHER
      r
  }
  case object unknownToSdkVersion extends zio.aws.comprehend.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.EntityType =
      software.amazon.awssdk.services.comprehend.model.EntityType.UNKNOWN_TO_SDK_VERSION
  }
  case object PERSON extends zio.aws.comprehend.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.EntityType =
      software.amazon.awssdk.services.comprehend.model.EntityType.PERSON
  }
  case object LOCATION extends zio.aws.comprehend.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.EntityType =
      software.amazon.awssdk.services.comprehend.model.EntityType.LOCATION
  }
  case object ORGANIZATION extends zio.aws.comprehend.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.EntityType =
      software.amazon.awssdk.services.comprehend.model.EntityType.ORGANIZATION
  }
  case object COMMERCIAL_ITEM extends zio.aws.comprehend.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.EntityType =
      software.amazon.awssdk.services.comprehend.model.EntityType.COMMERCIAL_ITEM
  }
  case object EVENT extends zio.aws.comprehend.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.EntityType =
      software.amazon.awssdk.services.comprehend.model.EntityType.EVENT
  }
  case object DATE extends zio.aws.comprehend.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.EntityType =
      software.amazon.awssdk.services.comprehend.model.EntityType.DATE
  }
  case object QUANTITY extends zio.aws.comprehend.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.EntityType =
      software.amazon.awssdk.services.comprehend.model.EntityType.QUANTITY
  }
  case object TITLE extends zio.aws.comprehend.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.EntityType =
      software.amazon.awssdk.services.comprehend.model.EntityType.TITLE
  }
  case object OTHER extends zio.aws.comprehend.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.EntityType =
      software.amazon.awssdk.services.comprehend.model.EntityType.OTHER
  }
}
