package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSentimentDetectionJobsResponse(
    sentimentDetectionJobPropertiesList: Optional[
      Iterable[zio.aws.comprehend.model.SentimentDetectionJobProperties]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse = {
    import ListSentimentDetectionJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse
      .builder()
      .optionallyWith(
        sentimentDetectionJobPropertiesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sentimentDetectionJobPropertiesList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ListSentimentDetectionJobsResponse.ReadOnly =
    zio.aws.comprehend.model.ListSentimentDetectionJobsResponse
      .wrap(buildAwsValue())
}
object ListSentimentDetectionJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.ListSentimentDetectionJobsResponse =
      zio.aws.comprehend.model.ListSentimentDetectionJobsResponse(
        sentimentDetectionJobPropertiesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def sentimentDetectionJobPropertiesList: Optional[
      List[zio.aws.comprehend.model.SentimentDetectionJobProperties.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getSentimentDetectionJobPropertiesList: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.SentimentDetectionJobProperties.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "sentimentDetectionJobPropertiesList",
      sentimentDetectionJobPropertiesList
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse
  ) extends zio.aws.comprehend.model.ListSentimentDetectionJobsResponse.ReadOnly {
    override val sentimentDetectionJobPropertiesList: Optional[
      List[zio.aws.comprehend.model.SentimentDetectionJobProperties.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sentimentDetectionJobPropertiesList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.SentimentDetectionJobProperties.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse
  ): zio.aws.comprehend.model.ListSentimentDetectionJobsResponse.ReadOnly =
    new Wrapper(impl)
}
