package zio.aws.comprehend.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.comprehend.model.primitives.{PolicyRevisionId, Timestamp, Policy}
import scala.jdk.CollectionConverters._
final case class DescribeResourcePolicyResponse(
    resourcePolicy: Optional[Policy] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    policyRevisionId: Optional[PolicyRevisionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeResourcePolicyResponse = {
    import DescribeResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeResourcePolicyResponse
      .builder()
      .optionallyWith(
        resourcePolicy.map(value => Policy.unwrap(value): java.lang.String)
      )(_.resourcePolicy)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        policyRevisionId.map(value =>
          PolicyRevisionId.unwrap(value): java.lang.String
        )
      )(_.policyRevisionId)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DescribeResourcePolicyResponse.ReadOnly =
    zio.aws.comprehend.model.DescribeResourcePolicyResponse
      .wrap(buildAwsValue())
}
object DescribeResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DescribeResourcePolicyResponse =
      zio.aws.comprehend.model.DescribeResourcePolicyResponse(
        resourcePolicy.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        policyRevisionId.map(value => value)
      )
    def resourcePolicy: Optional[Policy]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def policyRevisionId: Optional[PolicyRevisionId]
    def getResourcePolicy: ZIO[Any, AwsError, Policy] =
      AwsError.unwrapOptionField("resourcePolicy", resourcePolicy)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getPolicyRevisionId: ZIO[Any, AwsError, PolicyRevisionId] =
      AwsError.unwrapOptionField("policyRevisionId", policyRevisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeResourcePolicyResponse
  ) extends zio.aws.comprehend.model.DescribeResourcePolicyResponse.ReadOnly {
    override val resourcePolicy: Optional[Policy] = zio.aws.core.internal
      .optionalFromNullable(impl.resourcePolicy())
      .map(value => zio.aws.comprehend.model.primitives.Policy(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val policyRevisionId: Optional[PolicyRevisionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyRevisionId())
        .map(value =>
          zio.aws.comprehend.model.primitives.PolicyRevisionId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeResourcePolicyResponse
  ): zio.aws.comprehend.model.DescribeResourcePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
