package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DetectKeyPhrasesResponse(
    keyPhrases: Optional[Iterable[zio.aws.comprehend.model.KeyPhrase]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesResponse = {
    import DetectKeyPhrasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesResponse
      .builder()
      .optionallyWith(
        keyPhrases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keyPhrases)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DetectKeyPhrasesResponse.ReadOnly =
    zio.aws.comprehend.model.DetectKeyPhrasesResponse.wrap(buildAwsValue())
}
object DetectKeyPhrasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DetectKeyPhrasesResponse =
      zio.aws.comprehend.model.DetectKeyPhrasesResponse(
        keyPhrases.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def keyPhrases: Optional[List[zio.aws.comprehend.model.KeyPhrase.ReadOnly]]
    def getKeyPhrases: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.KeyPhrase.ReadOnly
    ]] = AwsError.unwrapOptionField("keyPhrases", keyPhrases)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesResponse
  ) extends zio.aws.comprehend.model.DetectKeyPhrasesResponse.ReadOnly {
    override val keyPhrases
        : Optional[List[zio.aws.comprehend.model.KeyPhrase.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyPhrases())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.KeyPhrase.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesResponse
  ): zio.aws.comprehend.model.DetectKeyPhrasesResponse.ReadOnly = new Wrapper(
    impl
  )
}
