package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  KmsKeyId,
  ClientRequestTokenString,
  JobName,
  IamRoleArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartKeyPhrasesDetectionJobRequest(
    inputDataConfig: zio.aws.comprehend.model.InputDataConfig,
    outputDataConfig: zio.aws.comprehend.model.OutputDataConfig,
    dataAccessRoleArn: IamRoleArn,
    jobName: Option[JobName] = None,
    languageCode: zio.aws.comprehend.model.LanguageCode,
    clientRequestToken: Option[ClientRequestTokenString] = None,
    volumeKmsKeyId: Option[KmsKeyId] = None,
    vpcConfig: Option[zio.aws.comprehend.model.VpcConfig] = None,
    tags: Option[Iterable[zio.aws.comprehend.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobRequest = {
    import StartKeyPhrasesDetectionJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobRequest
      .builder()
      .inputDataConfig(inputDataConfig.buildAwsValue())
      .outputDataConfig(outputDataConfig.buildAwsValue())
      .dataAccessRoleArn(IamRoleArn.unwrap(dataAccessRoleArn): java.lang.String)
      .optionallyWith(
        jobName.map(value => JobName.unwrap(value): java.lang.String)
      )(_.jobName)
      .languageCode(languageCode.unwrap)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestTokenString.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        volumeKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.volumeKmsKeyId)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.StartKeyPhrasesDetectionJobRequest.ReadOnly =
    zio.aws.comprehend.model.StartKeyPhrasesDetectionJobRequest
      .wrap(buildAwsValue())
}
object StartKeyPhrasesDetectionJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.StartKeyPhrasesDetectionJobRequest =
      zio.aws.comprehend.model.StartKeyPhrasesDetectionJobRequest(
        inputDataConfig.asEditable,
        outputDataConfig.asEditable,
        dataAccessRoleArn,
        jobName.map(value => value),
        languageCode,
        clientRequestToken.map(value => value),
        volumeKmsKeyId.map(value => value),
        vpcConfig.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def inputDataConfig: zio.aws.comprehend.model.InputDataConfig.ReadOnly
    def outputDataConfig: zio.aws.comprehend.model.OutputDataConfig.ReadOnly
    def dataAccessRoleArn: IamRoleArn
    def jobName: Option[JobName]
    def languageCode: zio.aws.comprehend.model.LanguageCode
    def clientRequestToken: Option[ClientRequestTokenString]
    def volumeKmsKeyId: Option[KmsKeyId]
    def vpcConfig: Option[zio.aws.comprehend.model.VpcConfig.ReadOnly]
    def tags: Option[List[zio.aws.comprehend.model.Tag.ReadOnly]]
    def getInputDataConfig
        : ZIO[Any, Nothing, zio.aws.comprehend.model.InputDataConfig.ReadOnly] =
      ZIO.succeed(inputDataConfig)
    def getOutputDataConfig: ZIO[
      Any,
      Nothing,
      zio.aws.comprehend.model.OutputDataConfig.ReadOnly
    ] = ZIO.succeed(outputDataConfig)
    def getDataAccessRoleArn: ZIO[Any, Nothing, IamRoleArn] =
      ZIO.succeed(dataAccessRoleArn)
    def getJobName: ZIO[Any, AwsError, JobName] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.comprehend.model.LanguageCode] =
      ZIO.succeed(languageCode)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestTokenString] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getVolumeKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("volumeKmsKeyId", volumeKmsKeyId)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.comprehend.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.comprehend.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobRequest
  ) extends zio.aws.comprehend.model.StartKeyPhrasesDetectionJobRequest.ReadOnly {
    override val inputDataConfig
        : zio.aws.comprehend.model.InputDataConfig.ReadOnly =
      zio.aws.comprehend.model.InputDataConfig.wrap(impl.inputDataConfig())
    override val outputDataConfig
        : zio.aws.comprehend.model.OutputDataConfig.ReadOnly =
      zio.aws.comprehend.model.OutputDataConfig.wrap(impl.outputDataConfig())
    override val dataAccessRoleArn: IamRoleArn =
      zio.aws.comprehend.model.primitives.IamRoleArn(impl.dataAccessRoleArn())
    override val jobName: Option[JobName] = scala
      .Option(impl.jobName())
      .map(value => zio.aws.comprehend.model.primitives.JobName(value))
    override val languageCode: zio.aws.comprehend.model.LanguageCode =
      zio.aws.comprehend.model.LanguageCode.wrap(impl.languageCode())
    override val clientRequestToken: Option[ClientRequestTokenString] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.comprehend.model.primitives.ClientRequestTokenString(value)
      )
    override val volumeKmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.volumeKmsKeyId())
      .map(value => zio.aws.comprehend.model.primitives.KmsKeyId(value))
    override val vpcConfig
        : Option[zio.aws.comprehend.model.VpcConfig.ReadOnly] = scala
      .Option(impl.vpcConfig())
      .map(value => zio.aws.comprehend.model.VpcConfig.wrap(value))
    override val tags: Option[List[zio.aws.comprehend.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobRequest
  ): zio.aws.comprehend.model.StartKeyPhrasesDetectionJobRequest.ReadOnly =
    new Wrapper(impl)
}
