package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribePiiEntitiesDetectionJobResponse(
    piiEntitiesDetectionJobProperties: Option[
      zio.aws.comprehend.model.PiiEntitiesDetectionJobProperties
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobResponse = {
    import DescribePiiEntitiesDetectionJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobResponse
      .builder()
      .optionallyWith(
        piiEntitiesDetectionJobProperties.map(value => value.buildAwsValue())
      )(_.piiEntitiesDetectionJobProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DescribePiiEntitiesDetectionJobResponse.ReadOnly =
    zio.aws.comprehend.model.DescribePiiEntitiesDetectionJobResponse
      .wrap(buildAwsValue())
}
object DescribePiiEntitiesDetectionJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.DescribePiiEntitiesDetectionJobResponse =
      zio.aws.comprehend.model.DescribePiiEntitiesDetectionJobResponse(
        piiEntitiesDetectionJobProperties.map(value => value.asEditable)
      )
    def piiEntitiesDetectionJobProperties: Option[
      zio.aws.comprehend.model.PiiEntitiesDetectionJobProperties.ReadOnly
    ]
    def getPiiEntitiesDetectionJobProperties: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.PiiEntitiesDetectionJobProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "piiEntitiesDetectionJobProperties",
      piiEntitiesDetectionJobProperties
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobResponse
  ) extends zio.aws.comprehend.model.DescribePiiEntitiesDetectionJobResponse.ReadOnly {
    override val piiEntitiesDetectionJobProperties: Option[
      zio.aws.comprehend.model.PiiEntitiesDetectionJobProperties.ReadOnly
    ] = scala
      .Option(impl.piiEntitiesDetectionJobProperties())
      .map(value =>
        zio.aws.comprehend.model.PiiEntitiesDetectionJobProperties.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobResponse
  ): zio.aws.comprehend.model.DescribePiiEntitiesDetectionJobResponse.ReadOnly =
    new Wrapper(impl)
}
