package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  ClientRequestTokenString,
  JobName,
  IamRoleArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartPiiEntitiesDetectionJobRequest(
    inputDataConfig: zio.aws.comprehend.model.InputDataConfig,
    outputDataConfig: zio.aws.comprehend.model.OutputDataConfig,
    mode: zio.aws.comprehend.model.PiiEntitiesDetectionMode,
    redactionConfig: Option[zio.aws.comprehend.model.RedactionConfig] = None,
    dataAccessRoleArn: IamRoleArn,
    jobName: Option[JobName] = None,
    languageCode: zio.aws.comprehend.model.LanguageCode,
    clientRequestToken: Option[ClientRequestTokenString] = None,
    tags: Option[Iterable[zio.aws.comprehend.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.StartPiiEntitiesDetectionJobRequest = {
    import StartPiiEntitiesDetectionJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.StartPiiEntitiesDetectionJobRequest
      .builder()
      .inputDataConfig(inputDataConfig.buildAwsValue())
      .outputDataConfig(outputDataConfig.buildAwsValue())
      .mode(mode.unwrap)
      .optionallyWith(redactionConfig.map(value => value.buildAwsValue()))(
        _.redactionConfig
      )
      .dataAccessRoleArn(IamRoleArn.unwrap(dataAccessRoleArn): java.lang.String)
      .optionallyWith(
        jobName.map(value => JobName.unwrap(value): java.lang.String)
      )(_.jobName)
      .languageCode(languageCode.unwrap)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestTokenString.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.StartPiiEntitiesDetectionJobRequest.ReadOnly =
    zio.aws.comprehend.model.StartPiiEntitiesDetectionJobRequest
      .wrap(buildAwsValue())
}
object StartPiiEntitiesDetectionJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.StartPiiEntitiesDetectionJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.StartPiiEntitiesDetectionJobRequest =
      zio.aws.comprehend.model.StartPiiEntitiesDetectionJobRequest(
        inputDataConfig.asEditable,
        outputDataConfig.asEditable,
        mode,
        redactionConfig.map(value => value.asEditable),
        dataAccessRoleArn,
        jobName.map(value => value),
        languageCode,
        clientRequestToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def inputDataConfig: zio.aws.comprehend.model.InputDataConfig.ReadOnly
    def outputDataConfig: zio.aws.comprehend.model.OutputDataConfig.ReadOnly
    def mode: zio.aws.comprehend.model.PiiEntitiesDetectionMode
    def redactionConfig
        : Option[zio.aws.comprehend.model.RedactionConfig.ReadOnly]
    def dataAccessRoleArn: IamRoleArn
    def jobName: Option[JobName]
    def languageCode: zio.aws.comprehend.model.LanguageCode
    def clientRequestToken: Option[ClientRequestTokenString]
    def tags: Option[List[zio.aws.comprehend.model.Tag.ReadOnly]]
    def getInputDataConfig
        : ZIO[Any, Nothing, zio.aws.comprehend.model.InputDataConfig.ReadOnly] =
      ZIO.succeed(inputDataConfig)
    def getOutputDataConfig: ZIO[
      Any,
      Nothing,
      zio.aws.comprehend.model.OutputDataConfig.ReadOnly
    ] = ZIO.succeed(outputDataConfig)
    def getMode
        : ZIO[Any, Nothing, zio.aws.comprehend.model.PiiEntitiesDetectionMode] =
      ZIO.succeed(mode)
    def getRedactionConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.RedactionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("redactionConfig", redactionConfig)
    def getDataAccessRoleArn: ZIO[Any, Nothing, IamRoleArn] =
      ZIO.succeed(dataAccessRoleArn)
    def getJobName: ZIO[Any, AwsError, JobName] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.comprehend.model.LanguageCode] =
      ZIO.succeed(languageCode)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestTokenString] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.comprehend.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.StartPiiEntitiesDetectionJobRequest
  ) extends zio.aws.comprehend.model.StartPiiEntitiesDetectionJobRequest.ReadOnly {
    override val inputDataConfig
        : zio.aws.comprehend.model.InputDataConfig.ReadOnly =
      zio.aws.comprehend.model.InputDataConfig.wrap(impl.inputDataConfig())
    override val outputDataConfig
        : zio.aws.comprehend.model.OutputDataConfig.ReadOnly =
      zio.aws.comprehend.model.OutputDataConfig.wrap(impl.outputDataConfig())
    override val mode: zio.aws.comprehend.model.PiiEntitiesDetectionMode =
      zio.aws.comprehend.model.PiiEntitiesDetectionMode.wrap(impl.mode())
    override val redactionConfig
        : Option[zio.aws.comprehend.model.RedactionConfig.ReadOnly] = scala
      .Option(impl.redactionConfig())
      .map(value => zio.aws.comprehend.model.RedactionConfig.wrap(value))
    override val dataAccessRoleArn: IamRoleArn =
      zio.aws.comprehend.model.primitives.IamRoleArn(impl.dataAccessRoleArn())
    override val jobName: Option[JobName] = scala
      .Option(impl.jobName())
      .map(value => zio.aws.comprehend.model.primitives.JobName(value))
    override val languageCode: zio.aws.comprehend.model.LanguageCode =
      zio.aws.comprehend.model.LanguageCode.wrap(impl.languageCode())
    override val clientRequestToken: Option[ClientRequestTokenString] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.comprehend.model.primitives.ClientRequestTokenString(value)
      )
    override val tags: Option[List[zio.aws.comprehend.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.StartPiiEntitiesDetectionJobRequest
  ): zio.aws.comprehend.model.StartPiiEntitiesDetectionJobRequest.ReadOnly =
    new Wrapper(impl)
}
