package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopTargetedSentimentDetectionJobRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.StopTargetedSentimentDetectionJobRequest = {
    import StopTargetedSentimentDetectionJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.StopTargetedSentimentDetectionJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.StopTargetedSentimentDetectionJobRequest.ReadOnly =
    zio.aws.comprehend.model.StopTargetedSentimentDetectionJobRequest
      .wrap(buildAwsValue())
}
object StopTargetedSentimentDetectionJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.StopTargetedSentimentDetectionJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.StopTargetedSentimentDetectionJobRequest =
      zio.aws.comprehend.model.StopTargetedSentimentDetectionJobRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.StopTargetedSentimentDetectionJobRequest
  ) extends zio.aws.comprehend.model.StopTargetedSentimentDetectionJobRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.comprehend.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.StopTargetedSentimentDetectionJobRequest
  ): zio.aws.comprehend.model.StopTargetedSentimentDetectionJobRequest.ReadOnly =
    new Wrapper(impl)
}
