package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Entity(
    score: Option[Float] = None,
    `type`: Option[zio.aws.comprehend.model.EntityType] = None,
    text: Option[String] = None,
    beginOffset: Option[Integer] = None,
    endOffset: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.Entity = {
    import Entity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.Entity
      .builder()
      .optionallyWith(score.map(value => value: java.lang.Float))(_.score)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(text.map(value => value: java.lang.String))(_.text)
      .optionallyWith(beginOffset.map(value => value: java.lang.Integer))(
        _.beginOffset
      )
      .optionallyWith(endOffset.map(value => value: java.lang.Integer))(
        _.endOffset
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.Entity.ReadOnly =
    zio.aws.comprehend.model.Entity.wrap(buildAwsValue())
}
object Entity {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.comprehend.model.Entity] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.Entity =
      zio.aws.comprehend.model.Entity(
        score.map(value => value),
        `type`.map(value => value),
        text.map(value => value),
        beginOffset.map(value => value),
        endOffset.map(value => value)
      )
    def score: Option[Float]
    def `type`: Option[zio.aws.comprehend.model.EntityType]
    def text: Option[String]
    def beginOffset: Option[Integer]
    def endOffset: Option[Integer]
    def getScore: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("score", score)
    def getType: ZIO[Any, AwsError, zio.aws.comprehend.model.EntityType] =
      AwsError.unwrapOptionField("type", `type`)
    def getText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("text", text)
    def getBeginOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("beginOffset", beginOffset)
    def getEndOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("endOffset", endOffset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.Entity
  ) extends zio.aws.comprehend.model.Entity.ReadOnly {
    override val score: Option[Float] =
      scala.Option(impl.score()).map(value => value: Float)
    override val `type`: Option[zio.aws.comprehend.model.EntityType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.comprehend.model.EntityType.wrap(value))
    override val text: Option[String] =
      scala.Option(impl.text()).map(value => value: String)
    override val beginOffset: Option[Integer] =
      scala.Option(impl.beginOffset()).map(value => value: Integer)
    override val endOffset: Option[Integer] =
      scala.Option(impl.endOffset()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.Entity
  ): zio.aws.comprehend.model.Entity.ReadOnly = new Wrapper(impl)
}
