package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.ComprehendArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: ComprehendArn,
    tags: Iterable[zio.aws.comprehend.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.TagResourceRequest
      .builder()
      .resourceArn(ComprehendArn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.TagResourceRequest.ReadOnly =
    zio.aws.comprehend.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.TagResourceRequest =
      zio.aws.comprehend.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: ComprehendArn
    def tags: List[zio.aws.comprehend.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, ComprehendArn] =
      ZIO.succeed(resourceArn)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.comprehend.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.TagResourceRequest
  ) extends zio.aws.comprehend.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ComprehendArn =
      zio.aws.comprehend.model.primitives.ComprehendArn(impl.resourceArn())
    override val tags: List[zio.aws.comprehend.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.comprehend.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.TagResourceRequest
  ): zio.aws.comprehend.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
