package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{Timestamp, ComprehendArnName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class EntityRecognizerFilter(
    status: Option[zio.aws.comprehend.model.ModelStatus] = None,
    recognizerName: Option[ComprehendArnName] = None,
    submitTimeBefore: Option[Timestamp] = None,
    submitTimeAfter: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.EntityRecognizerFilter = {
    import EntityRecognizerFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerFilter
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        recognizerName.map(value =>
          ComprehendArnName.unwrap(value): java.lang.String
        )
      )(_.recognizerName)
      .optionallyWith(
        submitTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.submitTimeBefore)
      .optionallyWith(
        submitTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.submitTimeAfter)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.EntityRecognizerFilter.ReadOnly =
    zio.aws.comprehend.model.EntityRecognizerFilter.wrap(buildAwsValue())
}
object EntityRecognizerFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.EntityRecognizerFilter =
      zio.aws.comprehend.model.EntityRecognizerFilter(
        status.map(value => value),
        recognizerName.map(value => value),
        submitTimeBefore.map(value => value),
        submitTimeAfter.map(value => value)
      )
    def status: Option[zio.aws.comprehend.model.ModelStatus]
    def recognizerName: Option[ComprehendArnName]
    def submitTimeBefore: Option[Timestamp]
    def submitTimeAfter: Option[Timestamp]
    def getStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.ModelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getRecognizerName: ZIO[Any, AwsError, ComprehendArnName] =
      AwsError.unwrapOptionField("recognizerName", recognizerName)
    def getSubmitTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submitTimeBefore", submitTimeBefore)
    def getSubmitTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submitTimeAfter", submitTimeAfter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerFilter
  ) extends zio.aws.comprehend.model.EntityRecognizerFilter.ReadOnly {
    override val status: Option[zio.aws.comprehend.model.ModelStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.comprehend.model.ModelStatus.wrap(value))
    override val recognizerName: Option[ComprehendArnName] = scala
      .Option(impl.recognizerName())
      .map(value =>
        zio.aws.comprehend.model.primitives.ComprehendArnName(value)
      )
    override val submitTimeBefore: Option[Timestamp] = scala
      .Option(impl.submitTimeBefore())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val submitTimeAfter: Option[Timestamp] = scala
      .Option(impl.submitTimeAfter())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerFilter
  ): zio.aws.comprehend.model.EntityRecognizerFilter.ReadOnly = new Wrapper(
    impl
  )
}
