package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  PolicyRevisionId,
  ComprehendModelArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteResourcePolicyRequest(
    resourceArn: ComprehendModelArn,
    policyRevisionId: Option[PolicyRevisionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DeleteResourcePolicyRequest = {
    import DeleteResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DeleteResourcePolicyRequest
      .builder()
      .resourceArn(ComprehendModelArn.unwrap(resourceArn): java.lang.String)
      .optionallyWith(
        policyRevisionId.map(value =>
          PolicyRevisionId.unwrap(value): java.lang.String
        )
      )(_.policyRevisionId)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DeleteResourcePolicyRequest.ReadOnly =
    zio.aws.comprehend.model.DeleteResourcePolicyRequest.wrap(buildAwsValue())
}
object DeleteResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DeleteResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DeleteResourcePolicyRequest =
      zio.aws.comprehend.model.DeleteResourcePolicyRequest(
        resourceArn,
        policyRevisionId.map(value => value)
      )
    def resourceArn: ComprehendModelArn
    def policyRevisionId: Option[PolicyRevisionId]
    def getResourceArn: ZIO[Any, Nothing, ComprehendModelArn] =
      ZIO.succeed(resourceArn)
    def getPolicyRevisionId: ZIO[Any, AwsError, PolicyRevisionId] =
      AwsError.unwrapOptionField("policyRevisionId", policyRevisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DeleteResourcePolicyRequest
  ) extends zio.aws.comprehend.model.DeleteResourcePolicyRequest.ReadOnly {
    override val resourceArn: ComprehendModelArn =
      zio.aws.comprehend.model.primitives.ComprehendModelArn(impl.resourceArn())
    override val policyRevisionId: Option[PolicyRevisionId] = scala
      .Option(impl.policyRevisionId())
      .map(value => zio.aws.comprehend.model.primitives.PolicyRevisionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DeleteResourcePolicyRequest
  ): zio.aws.comprehend.model.DeleteResourcePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
