package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DominantLanguage(
    languageCode: Option[String] = None,
    score: Option[Float] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DominantLanguage = {
    import DominantLanguage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DominantLanguage
      .builder()
      .optionallyWith(languageCode.map(value => value: java.lang.String))(
        _.languageCode
      )
      .optionallyWith(score.map(value => value: java.lang.Float))(_.score)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DominantLanguage.ReadOnly =
    zio.aws.comprehend.model.DominantLanguage.wrap(buildAwsValue())
}
object DominantLanguage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DominantLanguage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DominantLanguage =
      zio.aws.comprehend.model.DominantLanguage(
        languageCode.map(value => value),
        score.map(value => value)
      )
    def languageCode: Option[String]
    def score: Option[Float]
    def getLanguageCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getScore: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("score", score)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DominantLanguage
  ) extends zio.aws.comprehend.model.DominantLanguage.ReadOnly {
    override val languageCode: Option[String] =
      scala.Option(impl.languageCode()).map(value => value: String)
    override val score: Option[Float] =
      scala.Option(impl.score()).map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DominantLanguage
  ): zio.aws.comprehend.model.DominantLanguage.ReadOnly = new Wrapper(impl)
}
